/* Functions related to drawing and eInk
 */

/* Copyright (C) 2012 JoppyFurr
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy 
 * of this software and associated documentation files (the "Software"), to 
 * deal in the Software without restriction, including without limitation the 
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or 
 * sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 * DEALINGS IN THE SOFTWARE.
 */

/* Thanks Geekmaster for helping out with some code suggestions :3 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <pthread.h>

#include "constants.h"
#include "drawing.h"

/* Update the eInk. If refresh is set, flash the screen (clears the frame buffer) */
void update(int refresh) {
    if(refresh) {
        /* Note: This will eraise the frame buffer */
        system("eips -d l=0,w=600,h=800 -f");
    }
    else {
        system("eips ''");
    }
}

/* Clear the frame buffer */
void clear(unsigned char *frame_buffer) {
    int x = 0;
    int y = 0;
    for(y = 0; y < HEIGHT; y++) {
        for(x = 0; x < WIDTH; x++) {
            frame_buffer[x + STRIDE * y] = 0;
        }
    }
}

/* Draw a white box outline */
void draw_box(unsigned char *frame_buffer, int start_x, int start_y, int width, int height) {
    int i = 0;

    /* Top and bottom lines */
    for(i = 0; i <= width; i++) {
        frame_buffer[start_x + i + STRIDE * start_y] = 255;
        frame_buffer[start_x + i + STRIDE * (start_y + height)] = 255;
    }

    /* Left and right lines */ 
    for(i = 0; i <= height; i++) {
        frame_buffer[start_x + STRIDE * (start_y + i)] = 255;
        frame_buffer[start_x + width + STRIDE * (start_y + i)] = 200;
    }
}

/* Fill rectangle with a grid */
void draw_grid(unsigned char *frame_buffer, int start_x, int start_y, int width, int height, int spacing) {
    int x = 0;
    int y = 0;
    
    for(y = start_y; y < start_y + height; y++) {                                             
        for(x = start_x; x < start_x + width; x++) {                                          
            if(((y - start_y) % spacing) == 0 || ((x - start_x) % spacing) == 0) {                              
                frame_buffer[x + STRIDE * y] = 255;                           
            }                                                                 
            else {                                                            
                frame_buffer[x + STRIDE * y] = 0;                             
            }                                                                 
        }                                                                     
    }
}

