#!/bin/sh
# --------------------------------------
#
#      Title: Story HD Synchronization
#     Author: Wermesz
#      email: wermesz@gmail.com
#    version: 1.1
# --------------------------------------

#get the work dir
WORK_DIR=$1

#configuration
SERVERS='ftp://ftp.gnu.org ftp://ftp.gnu.org'
USERNAMES='anonymous anonymous'
PASSWDS='"" ""'

LOCAL_DIRS=''$WORK_DIR'/shd_sync/download/gnu_bulletins '$WORK_DIR'/shd_sync/download/licenses'
REMOTE_DIRS='pub/gnu/GNUsBulletins pub/gnu/Licenses'

echo ""
echo "Story HD Synchronization v1.1"
echo ""

i=1;
#iterate over the servers
for SERVER in $SERVERS
do
	if [ $i -gt 1 ]
	then
		echo ""
		echo ""
	fi
	echo "Synchronizing with the below configuration:"
	SERVER=`echo $SERVERS | cut -d' ' -f$i`
	USERNAME=`echo $USERNAMES | cut -d' ' -f$i`
	PASSWD=`echo $PASSWDS | cut -d' ' -f$i`
	LOCAL_DIR=`echo $LOCAL_DIRS | cut -d' ' -f$i`
	REMOTE_DIR=`echo $REMOTE_DIRS | cut -d' ' -f$i`
	echo "SERVER[$SERVER]"
	echo "USERNAME[$USERNAME]"
	echo "PASSWD[$PASSWD]"
	echo "LOCAL_DIR[$LOCAL_DIR]"
	echo "REMOTE_DIR[$REMOTE_DIR]"
	echo ""

	#delete files that do no longer exist in the remote directory
	echo "Checking for files that have been deleted from the remote directory..."
	FILES=/root/shd/shd_local/*
	for f in `find $LOCAL_DIR/*`
	do
		if [ "$f" != "$LOCAL_DIR" ]
		then
	     		tf=`echo $f | sed 's|'$LOCAL_DIR'/|''|'`
        		if [ -d $f ]
        		then
                		tf=$tf"/"
        		fi
        		echo -n "$f... "
        		$WORK_DIR/"bin/wget" -S --spider --user="$USERNAME" --password="$PASSWD" $SERVER/$REMOTE_DIR/$tf 2>&1 \
        		| grep -E 'Remote file does not exist|Could not get file size|No such directory' \
        		&& rm -rf "$LOCAL_DIR/$tf" && echo "DELETED" \
        		|| echo "EXISTS"
		fi
	done

	#download or update local files
	echo ""
	echo "Downloading/updating files..."
	dir_count=`echo "$REMOTE_DIR" | grep -o "/" | wc -l`
	let "dir_count++"
	$WORK_DIR/"bin/wget" -N -r --directory-prefix="$LOCAL_DIR" -nH --cut-dirs=$dir_count --user="$USERNAME" --password="$PASSWD" "$SERVER/$REMOTE_DIR/*" 2>&1
	let "i++"
done

echo ""
echo "Synchronization finished!!!"
echo ""

