// games.js

var teamdiv = {
    $divteam: document.getElementById("TeamDiv"),
    $divtable: document.getElementById("TableDiv"),
    $divdebug: document.getElementById("DebugDiv"),
    $team1: "",
    $team2: "",
    $team3: "",
    $team4: "",
    $d1: "",
    $d2: "",
    $d3: "",
    $rule: "",
    debug: function(text) {
       if (this.$divdebug != null) {
          this.$divdebug.appendChild(document.createTextNode(text));
       }
    },
    sptag: function(team1, team2) {
       var erg1 = window.localStorage.getItem("H" + team1 + team2 + team1);
       var erg2 = window.localStorage.getItem("H" + team1 + team2 + team2);
       if (erg1 == null) {
         erg1 = "";
       }
       if (erg2 == null) {
         erg2 = "";
       }
       return '<td><img src="pix/' + team1 + '.gif">' + team1 + ' - <img src="pix/' + team2 + '.gif">' + team2 + '</td>'
       + '<td><input id="' + team1 + team2 + team1 + '" type="text" onchange="teamdiv.save(\'' + team1 + team2 + team1 + '\')" size=2 value="' + erg1 + '" /> : <input id="' + team1 + team2 + team2 + '" type="text" onchange="teamdiv.save(\'' + team1 + team2 + team2 + '\')" size=2 value="' + erg2 + '" /></td>';
    },
    save: function(pos) {
       var inputPosition = document.getElementById(pos);
       // this.$divdebug.innerHTML = "label: " + pos + " content: " + inputPosition.value ;
       window.localStorage.setItem("H" + pos, inputPosition.value);
       this.updateTable();
    },
    gameCheck: function(team1, team2, ind) {
       var e1 = window.localStorage.getItem("H" + team1 + team2 + team1);
       var e2 = window.localStorage.getItem("H" + team1 + team2 + team2);
       if (e1 == null) {
          e1 = window.localStorage.getItem("H" + team2 + team1 + team1);
       }
       if (e2 == null) {
          e2 = window.localStorage.getItem("H" + team2 + team1 + team2);
       }
       if (e1 == null) {
          window.localStorage.setItem(ind, "N.N.");
          return;
       }
       if (e2 == null) {
          window.localStorage.setItem(ind, "N.N.");
          return;
       }
       if (e1 == "") {
          window.localStorage.setItem(ind, "N.N.");
          return;
       }
       if (e2 == "") {
          window.localStorage.setItem(ind, "N.N.");
          return;
       }
       e1 = parseInt(e1);
       e2 = parseInt(e2);
       if (e1 >= e2) {
          window.localStorage.setItem(ind, team1);
       } else {
          window.localStorage.setItem(ind, team2);
       }
    },
    updateTable: function() {
       this.gameCheck(this.$team1, this.$team2, "H1");
       this.gameCheck(this.$team3, this.$team4, "H2");
    },
    getTeam: function(key) {
       var ret = window.localStorage.getItem(key);
       if (ret == null) {
          ret = 'N.N.';
       }
       return ret;
    },
    init: function() {
       this.$team1 = this.getTeam("S1");
       this.$team2 = this.getTeam("S3");
       this.$team3 = this.getTeam("S2");
       this.$team4 = this.getTeam("S4");
       this.$divteam.innerHTML = '<center><table id="table">'
       + '<tr><th colspan=2><center>26.06.</center></th></tr>'
       + '<tr>' + this.sptag(this.$team1, this.$team2) + '</tr>'
       + '<tr><th colspan=2><center>27.06.</center></th></tr>'
       + '<tr>' + this.sptag(this.$team3, this.$team4) + '</tr>'
       + '</table></center>';
       this.updateTable();
    }
};
teamdiv.init();

