// games.js

var teamdiv = {
    $divteam: document.getElementById("TeamDiv"),
    $divtable: document.getElementById("TableDiv"),
    $divdebug: document.getElementById("DebugDiv"),
    $team1: "",
    $team2: "",
    $team3: "",
    $team4: "",
    $d1: "",
    $d2: "",
    $d3: "",
    $rule: "",
    sptag: function(team1, team2) {
       var erg1 = window.localStorage.getItem("V" + team1 + team2 + team1);
       var erg2 = window.localStorage.getItem("V" + team1 + team2 + team2);
       if (erg1 == null) {
         erg1 = "";
       }
       if (erg2 == null) {
         erg2 = "";
       }
       return '<td><img src="pix/' + team1 + '.gif">' + team1 + ' - <img src="pix/' + team2 + '.gif">' + team2 + '</td>'
       + '<td><input id="' + team1 + team2 + team1 + '" type="text" onchange="teamdiv.save(\'' + team1 + team2 + team1 + '\')" size=2 value="' + erg1 + '" /> : <input id="' + team1 + team2 + team2 + '" type="text" onchange="teamdiv.save(\'' + team1 + team2 + team2 + '\')" size=2 value="' + erg2 + '" /></td>';
    },
    save: function(pos) {
       var inputPosition = document.getElementById(pos);
       // this.$divdebug.innerHTML = "label: " + pos + " content: " + inputPosition.value ;
       window.localStorage.setItem("V" + pos, inputPosition.value);
       this.updateTable();
    },
    teamLine: function(platz, team) {
       return '<tr><td>' + platz + '.</td><td><img src="pix/' + team.name + '.png"></td><td>' + team.name + "</td><td>" + team.punkte + "</td><td>" + team.ptore + ":" + team.mtore + "</td></tr>";
    },
    torDifferenzVergleich: function(t1, t2) {
       if (t1.ptore - t1.mtore < t2.ptore - t2.mtore) {
          return true;
       }
       if (t1.ptore - t1.mtore > t2.ptore - t2.mtore) {
          return false;
       }
       if (t1.ptore < t2.ptore) {
          return true;
       }
       if (t1.ptore > t2.ptore) {
          return false;
       }
       return false;
    },
    dirVergleich: function(t1, t2) {
       var e1 = window.localStorage.getItem("V" + t1.name + t2.name + t1.name);
       var e2 = window.localStorage.getItem("V" + t1.name + t2.name + t2.name);
       if (e1 == null) {
          e1 = window.localStorage.getItem("V" + t2.name + t1.name + t1.name);
       }
       if (e2 == null) {
          e2 = window.localStorage.getItem("V" + t2.name + t1.name + t2.name);
       }
       if (e1 == null) {
          return this.torDifferenzVergleich(t1, t2);
       }
       if (e2 == null) {
          return this.torDifferenzVergleich(t1, t2);
       }
       if (e1 == "") {
          return this.torDifferenzVergleich(t1, t2);
       }
       if (e2 == "") {
          return this.torDifferenzVergleich(t1, t2);
       }
       e1 = parseInt(e1);
       e2 = parseInt(e2);
       if (e1 < e2) {
          return true;
       }
       if (e1 > e2) {
          return false;
       }
       return this.torDifferenzVergleich(t1, t2);
    },
    posCheck: function(t1, t2) {
       if (t1.punkte < t2.punkte) {
          return true;
       }
       if (t1.punkte > t2.punkte) {
          return false;
       }
       return this.dirVergleich(t1, t2);
    },
    gameCheck: function(team1, team2) {
       var e1 = window.localStorage.getItem("V" + team1.name + team2.name + team1.name);
       var e2 = window.localStorage.getItem("V" + team1.name + team2.name + team2.name);
       if (e1 == null) {
          e1 = window.localStorage.getItem("V" + team2.name + team1.name + team1.name);
       }
       if (e2 == null) {
          e2 = window.localStorage.getItem("V" + team2.name + team1.name + team2.name);
       }
       if (e1 == null) {
          return;
       }
       if (e2 == null) {
          return;
       }
       if (e1 == "") {
          return;
       }
       if (e2 == "") {
          return;
       }
       e1 = parseInt(e1);
       e2 = parseInt(e2);
       if (e1 > e2) {
          team1.punkte += 3;
       } else if (e2 > e1) {
          team2.punkte += 3;
       } else {
          team1.punkte += 1;
          team2.punkte += 1;
       }
       team1.ptore += e1;
       team2.mtore += e1;
       team2.ptore += e2;
       team1.mtore += e2;
    },
    updateTable: function() {
       var team1Entry = {
          name: this.$team1,
          punkte: 0,
          ptore: 0,
          mtore: 0
       },
       team2Entry = {
          name: this.$team2,
          punkte: 0,
          ptore: 0,
          mtore: 0
       },
       team3Entry = {
          name: this.$team3,
          punkte: 0,
          ptore: 0,
          mtore: 0
       },
       team4Entry = {
          name: this.$team4,
          punkte: 0,
          ptore: 0,
          mtore: 0
       }
       this.gameCheck(team1Entry, team2Entry);
       this.gameCheck(team1Entry, team3Entry);
       this.gameCheck(team1Entry, team4Entry);
       this.gameCheck(team2Entry, team3Entry);
       this.gameCheck(team2Entry, team4Entry);
       this.gameCheck(team3Entry, team4Entry);
       if (this.posCheck(team1Entry, team2Entry)) {
          var t = team1Entry;
          team1Entry = team2Entry;
          team2Entry = t;
       }
       if (this.posCheck(team2Entry, team3Entry)) {
          var t = team2Entry;
          team2Entry = team3Entry;
          team3Entry = t;
       }
       if (this.posCheck(team3Entry, team4Entry)) {
          var t = team3Entry;
          team3Entry = team4Entry;
          team4Entry = t;
       }
       if (this.posCheck(team1Entry, team2Entry)) {
          var t = team1Entry;
          team1Entry = team2Entry;
          team2Entry = t;
       }
       if (this.posCheck(team2Entry, team3Entry)) {
          var t = team2Entry;
          team2Entry = team3Entry;
          team3Entry = t;
       }
       if (this.posCheck(team1Entry, team2Entry)) {
          var t = team1Entry;
          team1Entry = team2Entry;
          team2Entry = t;
       }
       this.$divtable.innerHTML='<br /><center><table id="teamTable">' + this.teamLine(1, team1Entry) + this.teamLine(2, team2Entry) + this.teamLine(3, team3Entry) + this.teamLine(4, team4Entry) + "</table></center>";
       window.localStorage.setItem(this.$rule + "1", team1Entry.name);
       window.localStorage.setItem(this.$rule + "2", team2Entry.name);
       window.localStorage.setItem(this.$rule + "3", team3Entry.name);
       window.localStorage.setItem(this.$rule + "4", team4Entry.name);
    },
    init: function() {
       this.$team1 = this.$divteam.innerHTML.substring(0,3);
       this.$team2 = this.$divteam.innerHTML.substring(4,7);
       this.$team3 = this.$divteam.innerHTML.substring(8,11);
       this.$team4 = this.$divteam.innerHTML.substring(12,15);
       this.$d1 = this.$divteam.innerHTML.substring(16,22);
       this.$d2 = this.$divteam.innerHTML.substring(23,29);
       this.$d3 = this.$divteam.innerHTML.substring(30,36);
       this.$rule = this.$divteam.innerHTML.substring(37,38);
       if (this.$rule == 'A') {
         this.$divteam.innerHTML = '<center><table id="table">'
         + '<tr><th colspan=2><center>' + this.$d1 + '</center></th></tr>'
         + '<tr>' + this.sptag(this.$team1, this.$team2) + '</tr><tr>' + this.sptag(this.$team3, this.$team4) + '</tr>'
         + '<tr><th colspan=2><center>' + this.$d2 + '</center></th></tr>'
         + '<tr>' + this.sptag(this.$team1, this.$team3) + '</tr><tr>' + this.sptag(this.$team2, this.$team4) + '</tr>'
         + '<tr><th colspan=2><center>' + this.$d3 + '</center></th></tr>'
         + '<tr>' + this.sptag(this.$team2, this.$team3) + '</tr><tr>' + this.sptag(this.$team4, this.$team1) + '</tr>'
         + '</table></center>';
       } else if (this.$rule == 'B') {
         this.$divteam.innerHTML = '<center><table id="table">'
         + '<tr><th colspan=2><center>' + this.$d1 + '</center></th></tr>'
         + '<tr>' + this.sptag(this.$team1, this.$team2) + '</tr><tr>' + this.sptag(this.$team3, this.$team4) + '</tr>'
         + '<tr><th colspan=2><center>' + this.$d2 + '</center></th></tr>'
         + '<tr>' + this.sptag(this.$team1, this.$team3) + '</tr><tr>' + this.sptag(this.$team2, this.$team4) + '</tr>'
         + '<tr><th colspan=2><center>' + this.$d3 + '</center></th></tr>'
         + '<tr>' + this.sptag(this.$team4, this.$team1) + '</tr><tr>' + this.sptag(this.$team2, this.$team3) + '</tr>'
         + '</table></center>';
       } else if (this.$rule == 'C') {
         this.$divteam.innerHTML = '<center><table id="table">'
         + '<tr><th colspan=2><center>' + this.$d1 + '</center></th></tr>'
         + '<tr>' + this.sptag(this.$team1, this.$team2) + '</tr><tr>' + this.sptag(this.$team3, this.$team4) + '</tr>'
         + '<tr><th colspan=2><center>' + this.$d2 + '</center></th></tr>'
         + '<tr>' + this.sptag(this.$team1, this.$team3) + '</tr><tr>' + this.sptag(this.$team2, this.$team4) + '</tr>'
         + '<tr><th colspan=2><center>' + this.$d3 + '</center></th></tr>'
         + '<tr>' + this.sptag(this.$team4, this.$team1) + '</tr><tr>' + this.sptag(this.$team2, this.$team3) + '</tr>'
         + '</table></center>';
       } else if (this.$rule == 'D') {
         this.$divteam.innerHTML = '<center><table id="table">'
         + '<tr><th colspan=2><center>' + this.$d1 + '</center></th></tr>'
         + '<tr>' + this.sptag(this.$team1, this.$team2) + '</tr><tr>' + this.sptag(this.$team3, this.$team4) + '</tr>'
         + '<tr><th colspan=2><center>' + this.$d2 + '</center></th></tr>'
         + '<tr>' + this.sptag(this.$team2, this.$team4) + '</tr><tr>' + this.sptag(this.$team1, this.$team3) + '</tr>'
         + '<tr><th colspan=2><center>' + this.$d3 + '</center></th></tr>'
         + '<tr>' + this.sptag(this.$team2, this.$team3) + '</tr><tr>' + this.sptag(this.$team4, this.$team1) + '</tr>'
         + '</table></center>';
      } else {
        this.$divteam.innerHTML = this.$rule;
      }
      // if (this.$divdebug != null) {
      //   this.$divdebug.appendChild(document.createTextNode(this.$divteam.innerHTML));
      // }
      this.updateTable();
    }
};
teamdiv.init();

