/* A simple terminal emulator.
 * Currently does not support any ANSI control codes. Plaintext only. 
 */

/* Copyright (C) 2012 JoppyFurr
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy 
 * of this software and associated documentation files (the "Software"), to 
 * deal in the Software without restriction, including without limitation the 
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or 
 * sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 * DEALINGS IN THE SOFTWARE.
 */

#include <stdio.h>
#include <stdlib.h>

#include "constants.h"
#include "drawing.h"
#include "font.h"
#include "text.h"

/* Read from a file and write output to a character buffer */
void terminal_output(unsigned char *frame_buffer, int file_fd, unsigned char *character_buffer, int *state) {

    int x_position = 0;
    int y_position = 0;
    unsigned int scroll = 1;
    int i = 0;
    int j = 0;

    int count = 0;
    unsigned char output_buffer[80] = { '\0' };
    unsigned char c = '\0';

    /* Clear the character buffer with spaces */
    for(i = 0; i < 1920; i++) {
        character_buffer[i] = ' ';
    }
    character_buffer[1920] = 0; /* Set the scroll to 0 */

    render(character_buffer, frame_buffer);
    if(*state == IDLE) {
        *state = UPDATE;
    }

    while(*state != EXIT) {
        count = read(file_fd, output_buffer, 80);
        if(count > 0) {
        
            for(j = 0; j < count; j++) {
            
                c = output_buffer[j];
            
                if(c == '\n' || x_position >= TERMINAL_WIDTH) {
                    y_position = (y_position + 1) % TERMINAL_HEIGHT;
                    scroll++;
                    for(i = y_position * TERMINAL_WIDTH; i < (y_position + 1) * TERMINAL_WIDTH; i++) { /* Clear the new line */
                        character_buffer[i] = ' ';
                    }
                    x_position = 0;
                }
                else if (c >= 0x20 && c <= 0x7E) { /* Printable character */
                    character_buffer[TERMINAL_WIDTH * y_position + x_position++] = c;
                }
                else if (c == 0x08) { /* Backspace */
                    x_position--;
                    if(x_position == -1) {
                        x_position = TERMINAL_WIDTH - 1;
                        y_position = (y_position + (TERMINAL_HEIGHT - 1)) % TERMINAL_HEIGHT;
                        character_buffer[TERMINAL_WIDTH * y_position + x_position] = ' ';
                    }
                }
                if(scroll > 23) {
                    character_buffer[1920] = scroll;
                }
            }
            character_buffer[x_position + TERMINAL_WIDTH * y_position] = 0x7F; /* Show the cursor */
            render(character_buffer, frame_buffer);
            character_buffer[x_position + TERMINAL_WIDTH * y_position] = ' ';
            if(*state == IDLE) {
                *state = UPDATE;
            }
        }
        usleep(1000000 / 60); /* Take a quick nap to save the battery */
    }

    *state = EXIT; /* We have reach EOF, so bash must have quit */
}

