/* A Keyboard demonstation.
 */

/* Copyright (C) 2012 JoppyFurr
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy 
 * of this software and associated documentation files (the "Software"), to 
 * deal in the Software without restriction, including without limitation the 
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or 
 * sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 * DEALINGS IN THE SOFTWARE.
 */

/* Display states */
#define IDLE 0
#define UPDATE 1
#define REFRESH 2
#define EXIT 3

/* Update the eInk. If refresh is set, the screen will be flashed and the frame buffer blanked out */
void update(int refresh);

/* Clear the frame buffer */
void clear(unsigned char *frame_buffer);

/* Draw the white outline of a box */
void draw_box(unsigned char *frame_buffer, int start_x, int start_y, int width, int height);

/* Fill a rectangle with a grid pattern */
void draw_grid(unsigned char *frame_buffer, int start_x, int start_y, int width, int height, int spacing);

