/* Name: main.c
 * Author: JoppyFurr
 * Description: My first play with Kindle code.
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/mman.h>

#define WIDTH 600
#define HEIGHT 800
#define STRIDE 608

#define FRAME_BUFFER "/dev/fb0"
#define TOUCH_SCREEN "/dev/input/event3"

#define UP 0
#define DOWN 1

void update(int refresh);

int main(int argc, char **argv) {
    int frame_buffer_fd = 0;
    int touch_screen_fd = 0;
    unsigned char *frame_buffer = NULL;
    unsigned char event_buffer[16];
    int x = 0; 
    int y = 0;
    int i = 0;
    int j = 0;
    int finger = UP;

    /* Open files related to the screen */
    frame_buffer_fd = open(FRAME_BUFFER, O_RDWR);
    if(frame_buffer_fd == -1) {
        fprintf(stderr, "Error: Could not open frame buffer.\n");
        exit(EXIT_FAILURE);
    }
    frame_buffer = mmap(0, STRIDE * HEIGHT, PROT_READ | PROT_WRITE, MAP_SHARED, frame_buffer_fd, 0);
    touch_screen_fd = open(TOUCH_SCREEN, O_RDONLY);   
    if(touch_screen_fd == -1) {
        fprintf(stderr, "Error: Could not open touch screen.\n");
        exit(EXIT_FAILURE);
    }

    /* Draw a background */
    for(y = 0; y < HEIGHT; y++) {
        for(x = 0; x < WIDTH; x++) {
            if((y % 32) == 0 || (x % 32) == 0) {
            	frame_buffer[x + STRIDE * y] = 255;
            }
            else {
            	frame_buffer[x + STRIDE * y] = 0;
            }
        }
    }
    update(0);
    
    /* Loop through touch screen input, writing pretty things to the screen */    
    while(1) {
        read(touch_screen_fd, event_buffer, 16);
        if(event_buffer[0x08] == 0x03) {
            switch(event_buffer[0x0A]) {
                case 0x35:
                    /* X Coordinate change */
                    x = (WIDTH * (event_buffer[0x0C] + (event_buffer[0x0D] << 8))) / 0x1000;
                    break;
                case 0x36:
                    /* Y Coordinate change */
                    y = (HEIGHT * (event_buffer[0x0C] + (event_buffer[0x0D] << 8))) / 0x1000;
                    break;
                case 0x39:
                    /* Finger up / down */
                    if(event_buffer[0x0C] == 0x00) {
                        printf("Finger 1 down.\n");
                        finger = DOWN;
                    }
                    else if(event_buffer[0x0C] == 0x01) {
                        printf("Finger 2 down.\n");
                        finger = DOWN;
                    }
                    else {
                        printf("Finger up.\n");
                        finger = UP;
                    }
                    break;
                default:
                    break;
            }
        }
        if(finger == DOWN) { /* Plot a white square where the finger is */
            for(i = -2; i < 3; i++) {
                for(j = -2; j < 3; j++) {
                    if(x + i >= 0 && x + i < 600 && y + j >= 0 && y + j < 800) {
                        frame_buffer[(x + i) + STRIDE * (y + j)] = 255;
                    }
                }
            }
            update(0); 
        }
        if(finger == UP) { /* Release your finger in the top right to exit */
            if(x > 500 && y < 100) {
                printf("Exiting.\n");
                break;
            }
        }
        /* usleep(1000000/60); Waiting for input already gives it a break. */
    }


    munmap(frame_buffer, STRIDE * HEIGHT);
    close(frame_buffer_fd);

    return EXIT_SUCCESS;
}

void update(int refresh) {
    if(refresh) {
        system("eips -f ''");
    }
    else {
        system("eips ''");
    }
}
