#!/bin/bash
# library of code and functions to rename folders from hidden to nonhidden, and vice versa
# author VaniaSpeedy

#VARIABLES
config="/mnt/us/extensions/FolderToggle/profile2/config"

# renames all files from .NAME to NAME
# input is from find command, #find . -maxdepth 1 -name ".*" -print
restore() {
    if [ $1 = "." ]
    then
    echo 'returning, "." is not a valid name'
    return
    else 

	origname=`echo $1|cut -c 3-`
        echo "origname="$origname

	newname=`echo $1|cut -c 4-`
        echo "newname="$newname
    #echo $origname $newname
    mv $origname $newname
    echo "moved" $origname "to" $newname
    fi
}

# moves folders to /mnt/us/.hidden
# input is read line by line from config file
hide() {
    if [ $1 = "." ] # redundant, but you never know
		then
        #echo "returning" 
        return

    elif [ ! -d $1 ] #folder doesn't exist, quit
		then
        #echo "folder doesnt exist, exiting" >> /mnt/us/hide_profile_1_called
        return

    else # all is well, continue
		origname=$1
		newname=`echo "../.hidden/"$1`
		mv $origname $newname
		#echo "moved" $origname "to" $newname >> /mnt/us/hide_profile_1_called
		
    fi
} #end hide()


# change dirs
cd /mnt/us/documents

#mntroot rw # is this neccesary?

# if hidden dir doesnt exist, make it
if [ ! -d /mnt/us/.hidden ]
	then
	mkdir /mnt/us/.hidden
	#echo "hidden dir made" >> /mnt/us/hide_profile_1_called
fi

#debug
#touch /mnt/us/hide_profile_1_called
#ls >> /mnt/us/hide_profile_1_called

#IFS work
SAVEIFS=$IFS
IFS=$(echo -en "\n\b")

while IFS= read -r file
do
	echo "calling for" $file #>> /mnt/us/hide_profile_1_called
	hide $file
done < $config

# restore IFS
IFS=$SAVEIFS

#mntroot ro


# refresh the home screen
#if flag empty, just refresh dbus. otherwise, reboot
if [ ! -f /mnt/us/extensions/FolderToggle/profile1/cycle ]
	then
	touch /mnt/us/extensions/FolderToggle/profile1/cycle # first cycle, make a flag	
	dbus-send --system /default com.lab126.powerd.resuming int32:1;exit # REFRESH
else # flag exists, delete it and reboot
	rm -f /mnt/us/extensions/FolderToggle/profile1/cycle
	shutdown -r now
fi


