#!/bin/bash
# library of code and functions to rename folders from hidden to nonhidden, and vice versa
# author VaniaSpeedy

#VARIABLES
config="/mnt/us/extensions/FolderToggle/profile1/config"

# moves folders back into documents
# input is from find command, #find . -maxdepth 1 -name ".*" -print
restore() {
    if [ $1 = "." ]
		then
		#echo 'returning, "." is not a valid name' # redundant
		return
		
    else 
		origname=$1
		newname=`echo "../documents/"$1`
		mv $origname $newname
		#echo "moved" $origname "to" $newname
		
    fi
}

# change dirs
cd /mnt/us/.hidden

#IFS work
SAVEIFS=$IFS
IFS=$(echo -en "\n\b")

#call loop to read config and move back folders
while IFS= read -r file
do
	echo "calling for" $file #>> /mnt/us/hide_profile_1_called
	restore $file
done < $config

# restore IFS
IFS=$SAVEIFS

# refresh the home screen
dbus-send --system /default com.lab126.powerd.resuming int32:1;exit