/**
 * SECTION:element-eink
 *
 * 
 * <title>Example launch line</title>
 * |[
 * gst-launch -v -m fakesrc ! eink ! fakesink silent=TRUE
 * ]|
 * </refsect2>
 */
#define VERSION "0.10.0"

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gst/gst.h>

#include "gsteink.h"

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <linux/fb.h>
#include <unistd.h>
#include <string.h>
#include <sys/mman.h>
#include <sys/ioctl.h>
#include <math.h>

GST_DEBUG_CATEGORY_STATIC (gst_eink_debug);
#define GST_CAT_DEFAULT gst_eink_debug

/* Filter signals and args */
enum
{
  /* FILL ME */
  LAST_SIGNAL
};

enum
{
  PROP_0,
  PROP_SILENT
};

/* the capabilities of the inputs and outputs.
 *
 * describe the real formats here.
 */
static GstStaticPadTemplate sink_factory = GST_STATIC_PAD_TEMPLATE ("sink",
    GST_PAD_SINK,
    GST_PAD_ALWAYS,
    GST_STATIC_CAPS ("video/x-raw-gray, bpp=8")
    );

static GstStaticPadTemplate src_factory = GST_STATIC_PAD_TEMPLATE ("src",
    GST_PAD_SRC,
    GST_PAD_ALWAYS,
    GST_STATIC_CAPS ("video/x-raw-gray, bpp=8")
    );

GST_BOILERPLATE (Gsteink, gst_eink, GstElement,
    GST_TYPE_ELEMENT);

static void gst_eink_set_property (GObject * object, guint prop_id,
    const GValue * value, GParamSpec * pspec);
static void gst_eink_get_property (GObject * object, guint prop_id,
    GValue * value, GParamSpec * pspec);

static gboolean gst_eink_set_caps (GstPad * pad, GstCaps * caps);
static GstFlowReturn gst_eink_chain (GstPad * pad, GstBuffer * buf);

/* GObject vmethod implementations */

static void
gst_eink_base_init (gpointer gclass)
{
  GstElementClass *element_class = GST_ELEMENT_CLASS (gclass);

  gst_element_class_set_details_simple(element_class,
    "Eink",
    "Eink display",
    "Eink display",
    "Ehhh");

  gst_element_class_add_pad_template (element_class,
      gst_static_pad_template_get (&src_factory));
  gst_element_class_add_pad_template (element_class,
      gst_static_pad_template_get (&sink_factory));
}

/* initialize the eink's class */
static void
gst_eink_class_init (GsteinkClass * klass)
{
  GObjectClass *gobject_class;
  GstElementClass *gstelement_class;

  gobject_class = (GObjectClass *) klass;
  gstelement_class = (GstElementClass *) klass;

  gobject_class->set_property = gst_eink_set_property;
  gobject_class->get_property = gst_eink_get_property;

  g_object_class_install_property (gobject_class, PROP_SILENT,
      g_param_spec_boolean ("silent", "Silent", "Produce verbose output ?",
          FALSE, G_PARAM_READWRITE));
}

/* initialize the new element
 * instantiate pads and add them to element
 * set pad calback functions
 * initialize instance structure
 */
static void
gst_eink_init (Gsteink * filter,
    GsteinkClass * gclass)
{
  filter->sinkpad = gst_pad_new_from_static_template (&sink_factory, "sink");
  gst_pad_set_setcaps_function (filter->sinkpad,
                                GST_DEBUG_FUNCPTR(gst_eink_set_caps));
  gst_pad_set_getcaps_function (filter->sinkpad,
                                GST_DEBUG_FUNCPTR(gst_pad_proxy_getcaps));
  gst_pad_set_chain_function (filter->sinkpad,
                              GST_DEBUG_FUNCPTR(gst_eink_chain));

  filter->srcpad = gst_pad_new_from_static_template (&src_factory, "src");
  gst_pad_set_getcaps_function (filter->srcpad,
                                GST_DEBUG_FUNCPTR(gst_pad_proxy_getcaps));

  gst_element_add_pad (GST_ELEMENT (filter), filter->sinkpad);
  gst_element_add_pad (GST_ELEMENT (filter), filter->srcpad);
  filter->silent = FALSE;
}

static void
gst_eink_set_property (GObject * object, guint prop_id,
    const GValue * value, GParamSpec * pspec)
{
  Gsteink *filter = GST_EINK (object);

  switch (prop_id) {
    case PROP_SILENT:
      filter->silent = g_value_get_boolean (value);
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
  }
}

static void
gst_eink_get_property (GObject * object, guint prop_id,
    GValue * value, GParamSpec * pspec)
{
  Gsteink *filter = GST_EINK (object);

  switch (prop_id) {
    case PROP_SILENT:
      g_value_set_boolean (value, filter->silent);
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
  }
}

/* GstElement vmethod implementations */

/* this function handles the link with other elements */

static gboolean
gst_eink_set_caps (GstPad * pad, GstCaps * caps)
{
  Gsteink *filter;
  GstPad *otherpad;

  filter = GST_EINK (gst_pad_get_parent (pad));
  otherpad = (pad == filter->srcpad) ? filter->sinkpad : filter->srcpad;
  gst_object_unref (filter);

  GstStructure *structure = gst_caps_get_structure (caps, 0); 
  gst_structure_get_int (structure, "width", &filter->width);
  gst_structure_get_int (structure, "height", &filter->height);

  return gst_pad_set_caps (otherpad, caps);
}


#if 1
#define ditheringMatrixX 16
#define ditheringMatrixY 16
static char ditheringMatrix[16][16] = {  
{ 0, 128, 32, 160, 8, 136, 40, 168, 2, 130, 34, 162, 10, 138, 42, 170 },   
{ 192, 64, 224, 96, 200, 72, 232, 104, 194, 66, 226, 98, 202, 74, 234, 106 },
{ 48, 176, 16, 144, 56, 184, 24, 152, 50, 178, 18, 146, 58, 186, 26, 154 },
{ 240, 112, 208, 80, 248, 120, 216, 88, 242, 114, 210, 82, 250,  122, 218, 90 },
{ 12, 140, 44, 172, 4, 132, 36, 164, 14, 142, 46, 174, 6, 134, 38,166 },
{ 204, 76, 236, 108, 196, 68, 228, 100, 206, 78, 238, 110, 198, 70, 230, 102 }, 
{ 60, 188, 28, 156, 52, 180, 20, 148, 62, 190, 30, 158, 54, 182, 22, 150 },  
{ 252, 124, 220, 92, 244, 116, 212, 84, 254, 126, 222, 94, 246,  118, 214, 86 },  
{ 3, 131, 35, 163, 11, 139, 43, 171, 1, 129, 33, 161, 9, 137, 41, 169 },  
{ 195, 67, 227, 99, 203, 75, 235, 107, 193, 65, 225, 97, 201, 73, 233, 105 },  
{ 51, 179, 19, 147, 59, 187, 27, 155, 49, 177, 17, 145, 57, 185,  25, 153 },  
{ 243, 115, 211, 83, 251, 123, 219, 91, 241, 113, 209, 81, 249,  121, 217, 89 },   
{ 15, 143, 47, 175, 7, 135, 39, 167, 13, 141, 45, 173, 5, 133, 37, 165 }, 
{ 207, 79, 239, 111, 199, 71, 231, 103, 205, 77, 237, 109, 197, 69, 229, 101 },   
{ 63, 191, 31, 159, 55, 183, 23, 151, 61, 189, 29, 157, 53, 181, 21, 149 }, 
{ 255, 127, 223, 95, 247, 119, 215, 87, 253, 125, 221, 93, 245, 117, 213, 85 }
};
#else
#define ditheringMatrixX 8
#define ditheringMatrixY 8
static char ditheringMatrix[8][8] = {  
{ 1, 49 , 13, 61, 4, 52, 16, 64},   
{ 33, 17, 45, 29, 36, 20, 48, 32},
{ 9,  57, 5,  53, 12, 60, 8,  56},
{ 41, 25, 37, 21, 44, 28, 40, 24},
{ 3,  51, 15, 63, 2,  50, 14, 62},   
{ 35, 19, 47, 31, 34, 18, 46, 30},
{ 11, 59, 7,  55, 10, 58, 6,  54},
{ 43, 27, 39, 23, 42, 26, 38, 22}
};
#endif

int ll = 0;
int lInit = 0;
unsigned char *data = 0;
static GstFlowReturn
gst_eink_chain (GstPad * pad, GstBuffer * buf)
{
  Gsteink *filter;
	int width = 608;
	int height = 800;
	int i = 0;
	int j = 0;
  int jStep = 0;
  int iStep = 0;
  char* pBuffer = 0;
  GstBuffer *gstBuf = 0;

  filter = GST_EINK (GST_OBJECT_PARENT (pad));

  int sz = 0;
  if ((sz = GST_BUFFER_SIZE(buf)) == 0)   { 
    GST_WARNING ("zero sized buffer");
    return gst_pad_push (filter->srcpad, buf);
  }
 
  //g_print ("width %d height %d sz %d \n", filter->width, filter->height, sz);
  if( filter->height > height || filter->width > width ) {
   	g_print ("filter->height > height || filter->width > width ");
    return gst_pad_push (filter->srcpad, buf);
  }

  jStep = (height - filter->height) / 2;
  iStep = (width - filter->width)   / 2;
	//g_print ("Dispaly size: %d x %d\n", width, height);
  //if(++ll % 2) {
  	//g_print ("skip frame %d \n", ll);
  //  return gst_pad_push (filter->srcpad, buf);
  //}

  pBuffer  = (char*)GST_BUFFER_DATA(buf);

 	// open framebuffer device and read out info
  if(data == 0) {
	int fd = open("/dev/fb0", O_RDWR);
                                                                  
	struct fb_var_screeninfo screeninfo;
	ioctl(fd, FBIOGET_VSCREENINFO, &screeninfo);

	data = (unsigned char*)
		mmap(0, width * height ,
			PROT_READ|PROT_WRITE, MAP_SHARED, fd, 0);
  }
#if 1  /*good */

  for (i = 1; i < filter->height; i++) {
      for (j = 1; j < filter->width; j++) {
        //pBuffer[filter->width * (i) + (j )]  = ditheringMatrix[j % ditheringMatrixX][i % ditheringMatrixX] 
        //- pBuffer[filter->width * (i) + (j )] >> 8;

        data[width * (i + jStep) + (j + iStep)]=  ditheringMatrix[j % ditheringMatrixX][i % ditheringMatrixX] 
        - pBuffer[filter->width * (i) + (j )] >> 8;

      }
  }
#endif

#if 0  /*good */
  for (i = 1; i < filter->height; i++) {
      for (j = 1; j < filter->width; j++) {
       if((pBuffer[filter->width * (i) + (j )] )<= ditheringMatrix[j % ditheringMatrixX][i % ditheringMatrixX]) {
          data[width * (i + jStep) + (j + iStep)]= 0;  
        } else {   
          data[width * (i + jStep) + (j + iStep)]= 255;  
        } 
      }
  }
#endif
	//munmap(data, width * height );
  system("eips ''");
  //if (fd >= 0) close(fd); 

  /* just push out the incoming buffer without touching it */
  return gst_pad_push (filter->srcpad, buf);
}


/* entry point to initialize the plug-in
 * initialize the plug-in itself
 * register the element factories and other features
 */
static gboolean
eink_init (GstPlugin * eink)
{
  /* debug category for fltering log messages
   *
   * exchange the string 'Template eink' with your description
   */
  GST_DEBUG_CATEGORY_INIT (gst_eink_debug, "eink",
      0, "Template eink");

  return gst_element_register (eink, "eink", GST_RANK_NONE,
      GST_TYPE_EINK);
}

/* PACKAGE: this is usually set by autotools depending on some _INIT macro
 * in configure.ac and then written into and defined in config.h, but we can
 * just set it ourselves here in case someone doesn't use autotools to
 * compile this code. GST_PLUGIN_DEFINE needs PACKAGE to be defined.
 */
#ifndef PACKAGE
#define PACKAGE "eink demo plugin"
#endif

/* gstreamer looks for this structure to register einks
 *
 * exchange the string 'Template eink' with your eink description
 */
GST_PLUGIN_DEFINE (
    GST_VERSION_MAJOR,
    GST_VERSION_MINOR,
    "eink player",
    "eink player",
    eink_init,
    VERSION,
    "",
    "",
    ""
)

