@echo off
setlocal

REM ----------------------------------------------------------------------------
REM  book
REM ----------------------------------------------------------------------------
set BookName=Test book
set Author=Myself
set FileName=test_doc.htm
set PubDate=june 1990
set Editor=ACME
set Comments="<div style='text-align: justify;'>This is a comment.</div>"
set CoverFile=test_couv.jpg

REM ----------------------------------------------------------------------------
REM  environment
REM ----------------------------------------------------------------------------
set PATH=c:\Program Files (x86)\Calibre2;%PATH%


REM ----------------------------------------------------------------------------
REM  HTML Input to EPUB Output
REM ----------------------------------------------------------------------------
set options=--input-profile default
set options=%options% --output-profile sony

REM ----------------------------------------------------------------------------
REM  INPUT OPTIONS
REM ----------------------------------------------------------------------------
REM set options=%options% --max-levels 5

REM ----------------------------------------------------------------------------
REM  OUTPUT OPTIONS
REM ----------------------------------------------------------------------------
set options=%options% --preserve-cover-aspect-ratio
set options=%options% --pretty-print

REM ----------------------------------------------------------------------------
REM  LOOK AND FEEL
REM ----------------------------------------------------------------------------
set options=%options% --base-font-size 0
set options=%options% --line-height 0
set options=%options% --margin-bottom 5.0
set options=%options% --margin-left 5.0
set options=%options% --margin-right 5.0
set options=%options% --margin-top 5.0
set options=%options% --minimum-line-height 120.0

REM ----------------------------------------------------------------------------
REM  HEURISTIC PROCESSING
REM ----------------------------------------------------------------------------

REM ----------------------------------------------------------------------------
REM  SEARCH AND REPLACE
REM ----------------------------------------------------------------------------
set options=%options% --sr1-replace "" --sr1-search "(@font-face([^}])+})|(font-family([^;])+;)|([&]|,[&])quot;Georgia[&]quot;|([&]|,[&])quot;serif[&]quot;|Georgia&quot;|serif&quot;"

REM ----------------------------------------------------------------------------
REM  STRUCTURE DETECTION
REM ----------------------------------------------------------------------------
set options=%options% --chapter "//*[((name()='h1' or name()='h2') and re:test(., '\s*((chapter|book|section|part)\s+)|((prolog|prologue|epilogue)(\s+|$))', 'i')) or @class = 'chapter']"
set options=%options% --chapter-mark "none"
set options=%options% --page-breaks-before "//*[name()='h1']"

REM ----------------------------------------------------------------------------
REM  TABLE OF CONTENTS
REM ----------------------------------------------------------------------------
set options=%options% --level1-toc "//h:h1" --level2-toc "//h:h2" --level3-toc "//h:h3" --max-toc-links 50
set options=%options% --toc-threshold 6

REM ----------------------------------------------------------------------------
REM  METADATA
REM ----------------------------------------------------------------------------
set options=%options% --author-sort "%Author%"
set options=%options% --authors "%Author%"
set options=%options% --publisher "%Editor%"
set options=%options% --comments %Comments%
set options=%options% --pubdate "%PubDate%"
set options=%options% --title "%BookName%"
set options=%options% --language fra
set options=%options% --cover "%CoverFile%"

REM ----------------------------------------------------------------------------
REM  DEBUG
REM ----------------------------------------------------------------------------
set options=%options% --verbose

REM ----------------------------------------------------------------------------
REM  conversion
REM ----------------------------------------------------------------------------

REM one-step conversion
ebook-convert.exe "%FileName%" one_step.epub %options%  1> one_step.log 2>&1

REM two-step conversion
echo ------- first step 1> two_steps.log 2>&1
ebook-convert.exe "%FileName%" tmp_oeb 1>> two_steps.log 2>&1
echo ------- second step 1>> two_steps.log 2>&1
ebook-convert.exe "tmp_oeb\%FileName%" two_steps.epub %options% 1>> two_steps.log 2>&1
echo ------- cleanup 1>> two_steps.log 2>&1
rd /S /Q tmp_oeb 1>> two_steps.log 2>&1


endlocal
