#!/bin/sh
tmp1=tmp.1$$
tmp2=tmp.2$$
tmp3=tmp.3$$
tmp4=tmp.4$$
trap "rm -f $tmp1 $tmp2 $tmp3 $tmp4" 0 1 2 3 15
rm -f $tmp1 $tmp2 $tmp3 $tmp4

PATH=.:$PATH

case `uname -m` in
x86_64|i86pc|i686)
	kindle=false
	loud=true
	dir=$HOME/kindle
	bloc=$dir
	db=$dir/cc.db
	json=$dir/collections.json
	;;
arm*)
	kindle=true
	loud=false
	dir=/mnt/us/extensions/d2j2d/bin
	bloc=/mnt/us/system
	db=/var/local/cc.db
	json=/mnt/us/system/collections.json
	;;
esac

scr ()
	{
	n=`expr $n + 1`
	m=`expr $n % 50` #50 row display of 40 columns
	if [ $m -eq 0 ]; then n=2; fi #skip first 2 lines
	eips 0 $n "                                        "
	eips 0 $n "$*"
	}

cd $dir

# 1. build collections.json from cc.db
# 2. <run calibre>
# 3. build cc.db from collections.json

rdb=true
rjs=false
reboot=false
dbg=
err=ok
while test $# -gt 0
do
	arg=$1
	case $arg in
	-db)	rdb=true ;;
	+db)	rdb=false ;;
	-json)	rjs=true ;;
	+json)	rjs=false ;;
	-reboot)	reboot=true ;;
	+reboot)	reboot=false ;;
	-debug)
		dbg=echo
		;;
	-DEBUG)
		if [ $kindle = true ]; then
			eips -c
			n=1
			dbg=scr
		else
			dbg=echo
		fi
		;;
	-v*)	loud=true ;;
	-q*)	loud=false ;;
	-help)	err=help ;;
	*)
		err="unknown arg $arg"
		break
		;;
	esac
	shift
	unset arg
done
if [ "$err" != "ok" ]; then
	if [ "$err" != "help" ]; then
		echo Error: $err 1>&2
	fi
	echo "Usage: `basename $0` [-db] [-json] [-reboot]" 1>&2
	echo "       where -db   restores latest backup of cc.db" 1>&2
	echo "             -json restores latest backup of collections.json" 1>&2
	exit 1
fi

if [ $rjs = true -a -s $json.1 ]; then
	$dbg rm -f $json
	$dbg cp -p $json.1 $json
fi

bd=`echo $db | sed -e 's;.*/;;' -e "s;^;$bloc/;"`
if [ $rdb = true -a -s $bd.1 ]; then
	$dbg rm -f $db
	$dbg cp -p $bd.1 $db
fi

if [ $reboot = true ]; then
	$dbg sleep 3
	$dbg /sbin/reboot
fi

exit 0
