#!/bin/sh
tmp1=tmp.1$$
tmp2=tmp.2$$
tmp3=tmp.3$$
tmp4=tmp.4$$
trap "rm -f $tmp1 $tmp2 $tmp3 $tmp4" 0 1 2 3 15
rm -f $tmp1 $tmp2 $tmp3 $tmp4

PATH=.:$PATH

case `uname -m` in
x86_64|i86pc|i686)
	kindle=false
	loud=true
	dir=$HOME/kindle
	bloc=$dir
	db=$dir/cc.db
	json=$dir/collections.json
	;;
arm*)
	kindle=true
	loud=false
	dir=/mnt/us/extensions/d2j2d/bin
	bloc=/mnt/us/system
	db=/var/local/cc.db
	json=/mnt/us/system/collections.json
	;;
esac

truncate=true

screen ()
{
	# 40 rows x 50 columns display
	s=1
	e=48
	l=`echo "$*" | cut -c ${s}-${e}`
	while [ -n "$l" ]
	do
		if [ -z "$scr_n" ]; then scr_n=2; fi
		m=`expr $scr_n % 39`
		if [ $m -eq 0 ]; then scr_n=2; fi #skip first 2 lines

		o="`echo "$l" | tr \!\' . | tr \#\^ _ | tr -cd ' -~'`"
		if [ $kindle = true ]; then
			eips 1 $scr_n "                                                "
			eips 1 $scr_n "$o" && scr_n=`expr $scr_n + 1`
		else
			echo "$o" && scr_n=`expr $scr_n + 1`
		fi

		if [ $truncate = true ]; then return; fi
		s=`expr $s + 48`
		e=`expr $e + 48`
		l=`echo "$*" | cut -c ${s}-${e}`
	done
}

spin ()
{
	if [ $kindle = true ]; then

#		if [ -z "$scr_z" ]; then scr_z=0; fi
#		scr_z=`expr \( $scr_z + 1 \) % 2`
#		case $scr_z in
#			0) c="+" ;;
#			1) c="x" ;;
#			esac
#		eips 43 2 "$c"

		if [ -z "$scr_z" ]; then scr_z=0; fi
		scr_z=`expr \( $scr_z + 1 \) % 49`
		if [ $scr_z -eq 0 ]; then scr_z=1; fi
		eips $scr_z 38 "."
		l=3
		if [ $scr_z -gt $l ]; then
			c=`expr $scr_z - $l`
			eips $c 38 " "
		fi
		if [ $scr_z -le $l ]; then
			c=`expr 48 - $l + $scr_z`
			eips $c 38 " "
		fi

	fi
}

file2scr ()
{
	file=$1
	if [ -s $file ]; then
		truncate=false

		while read line
		do
			$scr $line
		done < $file

		truncate=true
	fi
}

fatal ()
{
	$scr " "
	$scr FATAL ERROR: DATABASE UNCHANGED
	exit $1
}

cd $dir

# 1. build collections.json from cc.db
# 2. <run calibre>
# 3. build cc.db from collections.json

mbak=5
scr=echo
backup=
vacuum_when_done=true
update_access_time=true
create_collections=true
remove_empty_collections=true
reboot=false
now=0
err=ok
while test $# -gt 0
do
	arg=$1
	case $arg in
	-uat*only)	update_access_time=only ;;
	-uat)		update_access_time=true ;;
	+uat)		update_access_time=false ;;
	-cc)		create_collections=true ;;
	+cc)		create_collections=false ;;
	-cco|+cco)	;;
	-rec)		remove_empty_collections=true ;;
	+rec)		remove_empty_collections=false ;;
	-vac*)		vacuum_when_done=true ;;
	+vac*)		vacuum_when_done=false ;;
	-v*)		loud=true ;;
	-q*)		loud=false ;;
	-scr)		if [ $kindle = true ]; then loud=true; scr=screen; fi ;;
	-help)		err=help ;;
	-reboot)	reboot=true ;;
	+reboot)	reboot=false ;;
	-now|-time)
		shift; if [ $# -eq 0 ]; then err="$arg syntax"; break; fi
		now=$1
		;;
	-bak|-back*)
		shift; if [ $# -eq 0 ]; then err="$arg syntax"; break; fi
		mbak=`expr $1 + 0`
		if [ -z "$mbak" ]; then err="$arg syntax"; break; fi
		;;
	+bak)	mbak=0 ;;
	*)
		err="unknown arg $arg"
		break
		;;
	esac
	shift
	unset arg
done
if [ "$err" != "ok" ]; then
	if [ "$err" != "help" ]; then
		echo Error: $err 1>&2
	fi
	echo "Usage: `basename $0` [-v] [-scr] [-bak <copies>] [+rec] [+vac] [+uat] [-uat_only]" 1>&2
	echo "                  [-cc] [-now time]" 1>&2
	echo "       where -scr writes progress to the Kindle screen" 1>&2
	echo "             -bak specifies the number of copies of cc.db to keep" 1>&2
	echo "                  [default = 0]" 1>&2
	echo "             +rec does not delete empty collections" 1>&2
	echo "             +vac does not truncate the collections journal and" 1>&2
	echo "                  rebuild the database" 1>&2
	echo "             +uat disables update of access times" 1>&2
	echo "             -now sets access times to specified value" 1>&2
	echo "                  [default = current time]" 1>&2
	echo "             +cc  disables creation of collections" 1>&2
	exit 1
fi

loadlib=".load ./libfoo.so"

if [ $kindle = true ]; then
	if [ $scr = screen ]; then
		eips -c
	else
		eips -g ../etc/importing.png -f -x 0 -y 30
	fi
fi

dbme ()
{
	coll=$1
	shift
	sqlite3 $dbtmp <<-EOF >$tmp2
	SELECT p_uuid FROM "Entries" WHERE p_type = "Collection" and p_titles_0_nominal = "$coll";
	EOF
	cid=`cat $tmp2`
	if [ -z "$cid" ]; then
		if [ $create_collections != true ]; then
			echo skip collection $coll without uuid
			continue
		fi
		cquote=`echo $coll | sed -e "s/'/''/g"`
		cstrip=`echo $coll | sed -e "s/['?!,\&;:\.]//g"`
		: create an entry for the new collection
		sqlite3 $dbtmp <<-EOF >$tmp2
		$loadlib
		CREATE TEMP TABLE IF NOT EXISTS "tmp" ( p_uuid TEXT );
		DELETE FROM tmp;
		INSERT INTO tmp VALUES(uuidize(lower(hex(randomblob(16)))));
		INSERT INTO "Entries" VALUES((select p_uuid from tmp),'Collection',NULL,$now,NULL,0,'$cquote','$cstrip','$cquote','[{"direction":"LTR","collation":"$cstrip","pronunciation":"$cquote","display":"$cquote","language":"en-US"}]',1,NULL,'[]',0,'[]',0,'[]',0,NULL,NULL,NULL,NULL,NULL,1,1,NULL,0,0,NULL,'[]',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'[{"ref":"titles"}]',NULL,NULL,NULL,NULL,NULL,NULL,0,2147483647,0,0);
		SELECT p_uuid FROM tmp;
		EOF
		x=`wc -l $tmp2 | sed -e 's/^ * //' -e 's/ .*$//'`
		if [ "$x" != "1" ]; then
			file2scr $tmp2
			fatal 2
		fi
		if [ $x -ne 1 ]; then
			echo error creating uuid for collection $coll
			continue
		fi
		cid=`cat $tmp2`
	fi
	if [ $loud = true ]; then
		$scr process collection $coll
	fi
	rm -f $tmp3
	touch $tmp3
	k=0
	members=
	for key in $*
	do
		: find books by key
		for type in EBOK PDOC
		do
			book=`echo $key | sed -e 's/^#//' -e 's/\^'$type'$//'`
			sqlite3 $dbtmp <<-EOF >$tmp2
			SELECT p_uuid FROM "Entries" WHERE p_type LIKE "Entry:Item%" AND p_cdeKey = "$book" AND p_cdeType = "$type" AND p_location LIKE "%/calibre/%";
			EOF
			bid=`cat $tmp2`
			if [ -n "$bid" ]; then break; fi
		done
		if [ -z "$bid" ]; then
			echo "    cannot find cdeKey $key from collection $coll" >>$tmp3
			continue
		fi
		: check that we only found one book with the key
		x=`wc -l $tmp2 | sed -e 's/^ * //' -e 's/ .*$//'`
		if [ "$x" != "1" ]; then
			echo multiple books with cdeKey $book in collection $coll >>$tmp3
			sqlite3 $dbtmp <<-EOF >>$tmp3
			SELECT p_titles_0_nominal,p_location FROM "Entries" WHERE p_type LIKE "Entry:Item%" AND p_cdeKey = "$book";
			EOF
			file2scr $tmp3
			fatal 3
		fi
		if [ $k -eq 0 ]; then
			cat <<-EOF >>$tmp4
			-- Collection: $coll
			DELETE FROM Collections WHERE i_collection_uuid = "$cid";
			EOF
		fi
		: find existing collection list for book
		sqlite3 $dbtmp <<-EOF >$tmp2
		SELECT p_collectionCount,j_collections FROM "Entries" WHERE p_uuid = "$bid";
		EOF
		c_numb=`cat $tmp2|sed -e 's/|.*$//'`
		c_list=`cat $tmp2|sed -e 's/.*|//' -e 's/]$//'`
		: add collection to book collection list
		if [ $c_numb -eq 0 ]; then
			c_list=$c_list\"$cid\"\]
		else
			c_list=$c_list,\"$cid\"\]
		fi
		c_numb=`expr $c_numb + 1`
		: update book collection list
		sqlite3 $dbtmp <<-EOF >$tmp2
		$loadlib
		UPDATE "Entries" SET p_collectionCount = $c_numb , j_collections = '$c_list' WHERE p_uuid = "$bid";
		select p_titles_0_nominal from "Entries" where p_uuid = "$bid";
		EOF
		title=`cat $tmp2`
		if [ $loud = true ]; then
			$scr "    $title"
		else
			spin
		fi
		cat <<-EOF >>$tmp4
		-- Entry: $title
		-- update "Entries" set p_collectionCount = $c_numb , j_collections = '$c_list' where p_uuid = "$bid";
		EOF
		: add title to collection
		k=`expr $k + 1`
		cat <<-EOF >>$tmp4
		INSERT INTO "Collections" VALUES('$cid','$bid',$k,'$type','$book',1);
		EOF
		: add book to members
		if [ -z "$members" ]; then
			members=\"$bid\"
		else
			members=$members,\"$bid\"
		fi
	done
	if [ $loud = debug ]; then
		$scr collection $coll count $k
	fi
	if [ $k -eq 0 ]; then
		if [ $remove_empty_collections = true ]; then
			sqlite3 $dbtmp <<-EOF >$tmp2
			$loadlib
			SELECT p_memberCount FROM Entries WHERE p_uuid = "$cid";
			EOF
			k=`cat $tmp2`
			if [ $loud = debug ]; then
				$scr "    member count $k"
			fi
			x=`wc -l $tmp2 | sed -e 's/^ * //' -e 's/ .*$//'`
			if [ "$x" = "1" ]; then
				if [ $k -eq 0 ]; then
					k=-1
					if [ $loud = true -o $loud = debug ]; then
						$scr "    delete empty collection"
					fi
					cat <<-EOF >>$tmp4
					-- Delete Collection: $coll
					DELETE FROM Entries WHERE p_uuid = "$cid";
					DELETE FROM Collections WHERE i_collection_uuid = "$cid";
					EOF
				fi
			fi
		fi
		if [ $k -ge 0 ]; then
			if [ $loud = true -o $loud = debug ]; then
				$scr "    collection has no calibre content"
			fi
		fi
	else
		file2scr $tmp3
		cat <<-EOF >>$tmp4
		-- Members of Collection: $coll
		update Entries set p_memberCount = $k , j_members = '[$members]' where p_uuid = "$cid";
		EOF
	fi
}

# execution starts here

: keep mbak copies of the database in bloc
bd=`echo $db | sed -e 's;.*/;;' -e "s;^;$bloc/;"`
dbtmp=$bd.0
if [ $mbak -gt 0 ]; then
	rm -f $bd.$mbak
	m=$mbak
	while [ $m -gt 1 ]
	do
		n=$m
		m=`expr $m - 1`
		if [ -f $bd.$m ]; then
			mv -i $bd.$m $bd.$n
		fi
	done
	cp -p $db $bd.1
fi
rm -f $dbtmp
cp -p $db $dbtmp
rv=$?
if [ $rv -ne 0 ]; then
	fatal 0
fi

if [ $loud = debug ]; then
	$scr test loadable module and get current system time
fi
sqlite3 $dbtmp <<-EOF 1>$tmp2 2>$tmp1
$loadlib
CREATE TEMP TABLE IF NOT EXISTS "tmp" ( p_uuid TEXT );
DELETE FROM tmp;
INSERT INTO tmp VALUES(strftime('%s','now'));
SELECT p_uuid FROM tmp;
EOF
x=`wc -l $tmp1 | sed -e 's/^ * //' -e 's/ .*$//'`
if [ "$x" != "0" ]; then
	file2scr $tmp1
	fatal 1
fi
if [ "$now" = "0" ]; then
	now=`cat $tmp2`
fi

if [ $update_access_time = only ]; then
	dbtmp=$db
else
	if [ $loud = debug ]; then
		$scr initialize collection count for each entry
	fi
	sqlite3 $dbtmp <<-EOF
	$loadlib
	UPDATE "Entries" SET p_collectionCount = 0 , j_collections = '[]' WHERE p_type LIKE "Entry:Item%" AND p_location LIKE "%/calibre/%";
	EOF
fi

cat <<-EOF >$tmp4
$loadlib
BEGIN TRANSACTION;
EOF

if [ $update_access_time != only ]; then
	cp $json $tmp2
	echo "" >> $tmp2
	sed -e '/^$/d' -e 's/^{//' -e 's/}$//' -e 's/,"/, "/g' \
		-e 's/:{"items":\[/: {"items": [/g' \
		-e 's/"lastAccess":\([^ ]\)/"lastAccess": \1/g' \
		< $tmp2 > $tmp1

	state=0
	collection=
	keys=
	for line in `cat $tmp1`
	do
		if [ $state -eq 0 ]; then
			if [ "$line" = '{"items":' ]; then
				state=1
				collection=`echo $collection | sed -e 's/^"//' -e 's/@[^@]*$//'`
				keys=
			elif [ -z "$collection" ]; then
				collection=$line
			else
				collection="$collection $line"
			fi
		elif [ $state -eq 1 ]; then
			if [ "$line" = '"lastAccess":' ]; then
				state=2
			else
				l=`echo $line | sed -e 's/[,"\[]//g' -e 's/]//g'`
				keys="$keys $l"
			fi
		elif [ $state -eq 2 ]; then
			dbme "$collection" $keys
			state=0
			collection=
		fi
	done
fi

if [ $update_access_time != false ]; then
	cat <<-EOF >>$tmp4
	UPDATE "Entries" SET p_lastAccess = $now;
	EOF
fi

cat <<-EOF >>$tmp4
COMMIT;
EOF

if [ $vacuum_when_done = true ]; then
	cat <<-EOF >>$tmp4
	delete from "CollectionsJournal";
	VACUUM;
	EOF
fi

cat <<-EOF >>$tmp4
.quit
EOF

sqlite3 $dbtmp < $tmp4

if [ $scr = screen ]; then
	sleep 6
fi

if [ $update_access_time != only ]; then
	cp -p $dbtmp $db
	rm -f $dbtmp
fi

if [ $kindle = true ]; then
	if [ $reboot = true ]; then
		/sbin/reboot
	else
		# enable screen saver
		lipc-set-prop com.lab126.powerd powerButton 1
		# back to home
		lipc-set-prop com.lab126.powerd powerButton 1
	fi
fi

exit 0
cat /proc/sys/kernel/random/uuid
