#!/bin/sh
tmp1=tmp.1$$
tmp2=tmp.2$$
tmp3=tmp.3$$
tmp4=tmp.4$$
trap "rm -f $tmp1 $tmp2 $tmp3 $tmp4" 0 1 2 3 15
rm -f $tmp1 $tmp2 $tmp3 $tmp4

PATH=.:$PATH

case `uname -m` in
x86_64|i86pc|i686)
	kindle=false
	loud=true
	dir=$HOME/kindle
	bloc=$dir
	db=$dir/cc.db
	json=$dir/collections.json
	;;
arm*)
	kindle=true
	loud=false
	dir=/mnt/us/extensions/d2j2d/bin
	bloc=/mnt/us/system
	db=/var/local/cc.db
	json=/mnt/us/system/collections.json
	;;
esac

truncate=true

screen ()
{
	# 40 rows x 50 columns display
	s=1
	e=48
	l=`echo "$*" | cut -c ${s}-${e}`
	while [ -n "$l" ]
	do
		if [ -z "$scr_n" ]; then scr_n=2; fi
		m=`expr $scr_n % 39`
		if [ $m -eq 0 ]; then scr_n=2; fi #skip first 2 lines

		o="`echo "$l" | tr \!\' . | tr \#\^ _ | tr -cd ' -~'`"
		if [ $kindle = true ]; then
			eips 1 $scr_n "                                                "
			eips 1 $scr_n "$o" && scr_n=`expr $scr_n + 1`
		else
			echo "$o" && scr_n=`expr $scr_n + 1`
		fi

		if [ $truncate = true ]; then return; fi
		s=`expr $s + 48`
		e=`expr $e + 48`
		l=`echo "$*" | cut -c ${s}-${e}`
	done
}

spin ()
{
	if [ $kindle = true ]; then

#		if [ -z "$scr_z" ]; then scr_z=0; fi
#		scr_z=`expr \( $scr_z + 1 \) % 2`
#		case $scr_z in
#			0) c="+" ;;
#			1) c="x" ;;
#			esac
#		eips 43 2 "$c"

		if [ -z "$scr_z" ]; then scr_z=0; fi
		scr_z=`expr \( $scr_z + 1 \) % 49`
		if [ $scr_z -eq 0 ]; then scr_z=1; fi
		eips $scr_z 38 "."
		l=3
		if [ $scr_z -gt $l ]; then
			c=`expr $scr_z - $l`
			eips $c 38 " "
		fi
		if [ $scr_z -le $l ]; then
			c=`expr 48 - $l + $scr_z`
			eips $c 38 " "
		fi

	fi
}

file2scr ()
{
	file=$1
	if [ -s $file ]; then
		truncate=false

		while read line
		do
			$scr $line
		done < $file

		truncate=true
	fi
}

fatal ()
{
	$scr " "
	$scr FATAL ERROR: DATABASE UNCHANGED
	exit $1
}

cd $dir

# 1. build collections.json from cc.db
# 2. <run calibre>
# 3. build cc.db from collections.json

mbak=0
scr=echo
err=ok
while test $# -gt 0
do
	arg=$1
	case $arg in
	-v*)	loud=true ;;
	-q*)	loud=false ;;
	-scr)	if [ $kindle = true ]; then loud=true; scr=screen; fi ;;
	-help)	err=help ;;
	-bak|-back*)
		shift; if [ $# -eq 0 ]; then err="$arg syntax"; break; fi
		mbak=`expr $1 + 0`
		if [ -z "$mbak" ]; then err="$arg syntax"; break; fi
		;;
	+bak) mbak=0 ;;
	*)
		err="unknown arg $arg"
		break
		;;
	esac
	shift
	unset arg
done
if [ "$err" != "ok" ]; then
	if [ "$err" != "help" ]; then
		echo Error: $err 1>&2
	fi
	echo "Usage: `basename $0` [-v] [-scr] [-bak <copies>]" 1>&2
	echo "       where -bak specifies the number of copies of collections.json to keep" 1>&2
	echo "                  [default = 0]" 1>&2
	echo "             -scr writes progress to the Kindle screen" 1>&2
	exit 1
fi

if [ $kindle = true ]; then
	if [ $scr = screen ]; then
		eips -c
	else
		eips -g ../etc/exporting.png -f -x 0 -y 30
	fi
fi

sqlite3 $db <<-EOF >$tmp1
	select p_titles_0_nominal,p_lastAccess,j_members,j_titles from "Entries" where p_type = "Collection";
EOF

rm -f $tmp4
len=`wc -l $tmp1 | awk '{ print $1 }'`
i=0
while [ $i -lt $len ];
do
	i=`expr $i + 1`
	if [ $i -eq 1 ]; then head={ ; else head=; fi
	if [ $i -eq $len ]; then tail=} ; else tail=,; fi
	head -$i $tmp1 | tail -1 > $tmp2
	name=`cat $tmp2 | sed -e 's/|.*$//'`
	time=`cat $tmp2 | sed -e 's/[^|]*|//' -e 's/|.*$//'`
	members=`cat $tmp2 | sed -e 's/[^|]*|//' -e 's/[^|]*|//' -e 's/|.*$//'`
	lang=`cat $tmp2 | sed -e 's/[^|]*|//' -e 's/[^|]*|//' -e 's/[^|]*|//' -e 's/|.*$//'`
	n=`echo "$lang" | grep -c '"language":"'`
	if [ $n -eq 0 ]; then
		lang=
	else
		lang=`echo "$lang" | sed -e 's/.*"language":"/@/' -e 's/".*$//'`
	fi
	uuids=`echo "$members" | sed -e 's/^.//' -e 's/.$//' -e 's/,/ /g'`
	if [ $loud = true ]; then
		$scr "Collection $name"
	fi
	members=
	for u in $uuids
	do
		sqlite3 $db <<-EOF >$tmp3
			select p_titles_0_nominal,p_cdeKey,p_cdeType from "Entries" where p_type like "Entry:Item%" and p_uuid = $u;
		EOF
		entry=`cat $tmp3 | sed -e 's/|.*$//'`
		if [ $loud = true ]; then
			$scr "    $entry"
		else
			spin
		fi
		cdekey=`cat $tmp3 | sed -e 's/[^|]*|//' -e 's/|.*$//'`
		cdetyp=`cat $tmp3 | sed -e 's/[^|]*|//' -e 's/[^|]*|//' -e 's/|.*$//'`
		x=`echo "$cdekey" | cut -c1`
		if [ "$x" = "*" ]; then
			m="$cdekey"
		else
			m="#$cdekey^$cdetyp"
		fi
		if [ -z "$members" ]; then
			members=\[\"$m\"
		else
			members=$members,\"$m\"
		fi
	done
	if [ -z "$members" ]; then
		members=\[
	fi
	members=$members\]
	printf $head\""$name"$lang\":{\"items\":"$members",\"lastAccess\":$time}$tail >>$tmp4
done

: keep mbak copies of the collections file
if [ $mbak -gt 0 ]; then
	rm -f $json.$mbak
	m=$mbak
	while [ $m -gt 1 ]
	do
		n=$m
		m=`expr $m - 1`
		if [ -f $json.$m ]; then
			mv -i $json.$m $json.$n
		fi
	done
	if [ -f $json ]; then
		mv $json $json.1
	fi
fi
rm -f $json
if [ -s $tmp4 ]; then
	mv $tmp4 $json
else
	touch $json
fi

if [ $scr = screen ]; then
	sleep 6
fi
if [ $kindle = true ]; then
	# enable screen saver
	lipc-set-prop com.lab126.powerd powerButton 1
	# back to home
	lipc-set-prop com.lab126.powerd powerButton 1
fi

exit 0
