#!/usr/bin/python
#eMonitor by Kranu
#Version 2 (9-1-2011)

#modified by jmseight for iRiver Story HD (4-24-2012)
#  Rotate screen 90 deg
#  Made into grayscale image (original is color)
#  Reduce quality for faster load
#  Set to Story HD resolution


#Tested on Windows 7 x64, Python 2.7.2, wxPython 2.8
#For more information, see: http://goo.gl/rJoLp

#+---2-16-2012---+
#This is the same as v2
#Just using pygtk instead of wxWidgets. 
#Tested on Ubuntu

#BEGIN SETUP

#HTTP Server
port=8000              #port of http server (http://127.0.0.1:8000/)

#capture region
#l,t=(1680,1050-800)
l,t=(0,0)              #left and right offset from primary monitor
w,h=(1024,768)          #width and height of capture region
fn ='shot.jpg'         #file name of screenshot
quality = "50"

#//END SETUP

import pygtk, gtk, socket
from BaseHTTPServer import BaseHTTPRequestHandler, HTTPServer

class serv(BaseHTTPRequestHandler):
  def do_GET(self):
    self.send_response(200)
    if self.path.startswith('/'+fn):
      self.send_header('Content-type','image/jpeg')
      self.end_headers()
  
      screenshot =  gtk.gdk.Pixbuf.rotate_simple(
						gtk.gdk.Pixbuf.get_from_drawable(
							gtk.gdk.Pixbuf(gtk.gdk.COLORSPACE_RGB, True, 8, w, h),
							gtk.gdk.get_default_root_window(),
							gtk.gdk.colormap_get_system(),
							l, l, 0, 0, w, h),
						gtk.gdk.PIXBUF_ROTATE_COUNTERCLOCKWISE
					)

      screenshot.saturate_and_pixelate(screenshot, 0.0, False)
	  
      screenshot.save(fn, "jpeg", {"quality": quality})

      f=open(fn,'rb')
      self.wfile.write(f.read())
    else:
      self.send_header('Content-type','text/html')
      self.end_headers()
      self.wfile.write('<!doctype html>'\
        '<html lang="en">'\
        '<head>'\
        '<title>eMonitor by Kranu</title>'\
        '</head>'\
        '<body style="margin:0px;">'\
        '<img id="pic" src="'+fn+'" style="float:left;width:100%;height:100%;">'\
        '<script type="text/javascript">'\
        'document.getElementById("pic").onload=function() {'\
        '  document.getElementById("pic").src="'+fn+'?"+(new Date()).getTime();'\
        '}'\
        '</script>'\
        '</body>'\
        '</html>')
try:
  print 'eMonitor by Kranu'

  #Amazon's website is used here for its reliablity. Feel free to change it.
  s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
  s.connect(("amazon.com",80))

  print 'Starting.. ',
  server=HTTPServer(('',port),serv)
  print 'Press Ctrl+C to stop'
  print

  print 'On your Story HD, visit http://'+s.getsockname()[0]+':'+str(port)+'/'

  server.serve_forever()
except KeyboardInterrupt:
  print 'Stopping.. ',
  server.socket.close()
  print 'Have a nice day!'
