package com.lab126.util.fs;

import kindle.test.jni.JniLibrariesManager;

public class Util implements IUtil
{
    public Util() {}

    static
    {
		String loc = JniLibrariesManager.getInstance().getLibLocation("com.lab126.util.fs.Util");
		if(null != loc) {
			if(loc.endsWith(".so"))	{
				//lib is in whole name with extension so we need to use load
				System.load(loc);
			} else {
				//lib is in short form so we have to use loadLibrary
				System.loadLibrary(loc);
			}
		}
    }
    
    public native boolean setReadOnly(String s);
    public native boolean clearReadOnly(String s);
    public native boolean isReadOnly(String s);
    public native int openFile(String s, int i);
    public native int getFreeSpace(String s);
    public native int getCapacity(String s);
    public native void flushPendingWrites();
}
