/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent.locks;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Lock;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;

class CondVar
implements Condition,
Serializable {
    protected final ExclusiveLock lock;

    CondVar(ExclusiveLock lock) {
        this.lock = lock;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void awaitUninterruptibly() {
        int i3;
        int holdCount = this.lock.getHoldCount();
        if (holdCount == 0) {
            throw new IllegalMonitorStateException();
        }
        boolean wasInterrupted = Thread.interrupted();
        try {
            CondVar condVar = this;
            synchronized (condVar) {
                int i2 = holdCount;
                while (true) {
                    if (i2 <= 0) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ex) {
                            wasInterrupted = true;
                        }
                        break;
                    }
                    this.lock.unlock();
                    --i2;
                }
            }
            Object var8_6 = null;
            int i3 = holdCount;
            while (true) {
                if (i3 <= 0) break;
                this.lock.lock();
                --i3;
            }
            if (!wasInterrupted) return;
            Thread.currentThread().interrupt();
            return;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            i3 = holdCount;
        }
        while (true) {
            if (i3 <= 0) {
                if (!wasInterrupted) throw throwable;
                Thread.currentThread().interrupt();
                throw throwable;
            }
            this.lock.lock();
            --i3;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void await() throws InterruptedException {
        int i3;
        int holdCount = this.lock.getHoldCount();
        if (holdCount == 0) {
            throw new IllegalMonitorStateException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        try {
            CondVar condVar = this;
            synchronized (condVar) {
                int i2 = holdCount;
                while (true) {
                    if (i2 <= 0) {
                        try {
                            this.wait();
                            break;
                        }
                        catch (InterruptedException ex) {
                            this.notify();
                            throw ex;
                        }
                    }
                    this.lock.unlock();
                    --i2;
                }
            }
            Object var7_5 = null;
            int i3 = holdCount;
            while (i3 > 0) {
                this.lock.lock();
                --i3;
            }
            return;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            i3 = holdCount;
        }
        while (true) {
            if (i3 <= 0) {
                throw throwable;
            }
            this.lock.lock();
            --i3;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        int i3;
        int holdCount = this.lock.getHoldCount();
        if (holdCount == 0) {
            throw new IllegalMonitorStateException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        long nanos = unit.toNanos(timeout);
        boolean success = false;
        try {
            CondVar condVar = this;
            synchronized (condVar) {
                int i2 = holdCount;
                while (true) {
                    if (i2 <= 0) {
                        try {
                            if (nanos <= 0L) break;
                            long start = Utils.nanoTime();
                            TimeUnit.NANOSECONDS.timedWait(this, nanos);
                            success = Utils.nanoTime() - start < nanos;
                            break;
                        }
                        catch (InterruptedException ex) {
                            this.notify();
                            throw ex;
                        }
                    }
                    this.lock.unlock();
                    --i2;
                }
            }
            Object var14_10 = null;
            int i3 = holdCount;
            while (i3 > 0) {
                this.lock.lock();
                --i3;
            }
            return success;
        }
        catch (Throwable throwable) {
            Object var14_11 = null;
            i3 = holdCount;
        }
        while (true) {
            if (i3 <= 0) {
                throw throwable;
            }
            this.lock.lock();
            --i3;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean awaitUntil(Date deadline) throws InterruptedException {
        int i3;
        if (deadline == null) {
            throw new NullPointerException();
        }
        int holdCount = this.lock.getHoldCount();
        if (holdCount == 0) {
            throw new IllegalMonitorStateException();
        }
        long abstime = deadline.getTime();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        boolean success = false;
        try {
            CondVar condVar = this;
            synchronized (condVar) {
                int i2 = holdCount;
                while (true) {
                    if (i2 <= 0) {
                        try {
                            long start = System.currentTimeMillis();
                            long msecs = abstime - start;
                            if (msecs <= 0L) break;
                            this.wait(msecs);
                            success = System.currentTimeMillis() - start < msecs;
                            break;
                        }
                        catch (InterruptedException ex) {
                            this.notify();
                            throw ex;
                        }
                    }
                    this.lock.unlock();
                    --i2;
                }
            }
            Object var14_10 = null;
            int i3 = holdCount;
            while (i3 > 0) {
                this.lock.lock();
                --i3;
            }
            return success;
        }
        catch (Throwable throwable) {
            Object var14_11 = null;
            i3 = holdCount;
        }
        while (true) {
            if (i3 <= 0) {
                throw throwable;
            }
            this.lock.lock();
            --i3;
        }
    }

    public synchronized void signal() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        this.notify();
    }

    public synchronized void signalAll() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        this.notifyAll();
    }

    protected ExclusiveLock getLock() {
        return this.lock;
    }

    protected boolean hasWaiters() {
        throw new UnsupportedOperationException("Use FAIR version");
    }

    protected int getWaitQueueLength() {
        throw new UnsupportedOperationException("Use FAIR version");
    }

    protected Collection getWaitingThreads() {
        throw new UnsupportedOperationException("Use FAIR version");
    }

    static interface ExclusiveLock
    extends Lock {
        public boolean isHeldByCurrentThread();

        public int getHoldCount();
    }
}

