/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.AbstractQueue;
import edu.emory.mathcs.backport.java.util.PriorityQueue;
import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PriorityBlockingQueue
extends AbstractQueue
implements BlockingQueue,
Serializable {
    private static final long serialVersionUID = 5595510919245408276L;
    private final PriorityQueue q;
    private final ReentrantLock lock = new ReentrantLock(true);
    private final Condition notEmpty = this.lock.newCondition();

    public PriorityBlockingQueue() {
        this.q = new PriorityQueue();
    }

    public PriorityBlockingQueue(int initialCapacity) {
        this.q = new PriorityQueue(initialCapacity, null);
    }

    public PriorityBlockingQueue(int initialCapacity, Comparator comparator) {
        this.q = new PriorityQueue(initialCapacity, comparator);
    }

    public PriorityBlockingQueue(Collection c) {
        this.q = new PriorityQueue(c);
    }

    public boolean add(Object e) {
        return this.offer(e);
    }

    public boolean offer(Object e) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean ok = this.q.offer(e);
            this.notEmpty.signal();
            boolean bl = true;
            Object var6_5 = null;
            lock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public void put(Object e) {
        this.offer(e);
    }

    public boolean offer(Object e, long timeout, TimeUnit unit) {
        return this.offer(e);
    }

    public Object poll() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object object = this.q.poll();
            Object var4_3 = null;
            lock.unlock();
            return object;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public Object take() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            Object x;
            try {
                while (this.q.size() == 0) {
                    this.notEmpty.await();
                }
            }
            catch (InterruptedException ie) {
                this.notEmpty.signal();
                throw ie;
            }
            Object object = x = this.q.poll();
            Object var5_5 = null;
            lock.unlock();
            return object;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object poll(long timeout, TimeUnit unit) throws InterruptedException {
        block7: {
            nanos = unit.toNanos(timeout);
            lock = this.lock;
            lock.lockInterruptibly();
            try {
                deadline = Utils.nanoTime() + nanos;
                while (true) lbl-1000:
                // 2 sources

                {
                    if ((x = this.q.poll()) != null) {
                        var10_7 = x;
                        var14_8 = null;
                        lock.unlock();
                        return var10_7;
                    }
                    if (nanos <= 0L) {
                        var11_11 = null;
                        break block7;
                    }
                    try {
                        this.notEmpty.await(nanos, TimeUnit.NANOSECONDS);
                        nanos = deadline - Utils.nanoTime();
                        continue;
                    }
                    catch (InterruptedException ie) {
                        this.notEmpty.signal();
                        throw ie;
                    }
                    break;
                }
            }
            catch (Throwable var13_13) {
                var14_10 = null;
                lock.unlock();
                throw var13_13;
            }
            {
                ** while (true)
            }
        }
        var14_9 = null;
        lock.unlock();
        return var11_11;
    }

    public Object peek() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object object = this.q.peek();
            Object var4_3 = null;
            lock.unlock();
            return object;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public Comparator comparator() {
        return this.q.comparator();
    }

    public int size() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.q.size();
            Object var4_3 = null;
            lock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    public boolean remove(Object o) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.q.remove(o);
            Object var5_4 = null;
            lock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public boolean contains(Object o) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.q.contains(o);
            Object var5_4 = null;
            lock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public Object[] toArray() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] objectArray = this.q.toArray();
            Object var4_3 = null;
            lock.unlock();
            return objectArray;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public String toString() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            String string = this.q.toString();
            Object var4_3 = null;
            lock.unlock();
            return string;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int drainTo(Collection c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object e;
            int n = 0;
            while ((e = this.q.poll()) != null) {
                void var4_4;
                c.add(var4_4);
                ++n;
            }
            int n2 = n;
            Object var7_6 = null;
            lock.unlock();
            return n2;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int drainTo(Collection c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        if (maxElements <= 0) {
            return 0;
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object e;
            int n = 0;
            while (n < maxElements && (e = this.q.poll()) != null) {
                void var5_5;
                c.add(var5_5);
                ++n;
            }
            int n2 = n;
            Object var8_7 = null;
            lock.unlock();
            return n2;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public void clear() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.q.clear();
            Object var3_2 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public Object[] toArray(Object[] a) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] objectArray = this.q.toArray(a);
            Object var5_4 = null;
            lock.unlock();
            return objectArray;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public Iterator iterator() {
        return new Itr(this.toArray());
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.lock.lock();
        try {
            s.defaultWriteObject();
            Object var3_2 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    private class Itr
    implements Iterator {
        final Object[] array;
        int cursor;
        int lastRet = -1;

        Itr(Object[] array) {
            this.array = array;
        }

        public boolean hasNext() {
            return this.cursor < this.array.length;
        }

        public Object next() {
            if (this.cursor >= this.array.length) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor;
            return this.array[this.cursor++];
        }

        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            Object x = this.array[this.lastRet];
            this.lastRet = -1;
            PriorityBlockingQueue.this.lock.lock();
            try {
                Iterator it = PriorityBlockingQueue.this.q.iterator();
                while (it.hasNext()) {
                    if (it.next() != x) continue;
                    it.remove();
                    Object var4_3 = null;
                    PriorityBlockingQueue.this.lock.unlock();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                PriorityBlockingQueue.this.lock.unlock();
                throw throwable;
            }
            Object var4_4 = null;
            PriorityBlockingQueue.this.lock.unlock();
        }
    }
}

