/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.runtime13.v14.java.lang;

import java.awt.print.PrinterIOException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.WriteAbortedException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationException;
import java.rmi.server.ServerCloneException;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import javax.naming.NamingException;
import net.sf.retrotranslator.runtime13.impl.WeakIdentityTable;
import net.sf.retrotranslator.runtime13.v14.java.lang.StackTraceElement_;

public class _Throwable {
    private static final String TAB_AT_SPACE = "\tat ";
    private static final Throwable NULL = new Throwable();
    private static final WeakIdentityTable<Throwable, Throwable> causeTable = new WeakIdentityTable();

    public static ThrowableBuilder createInstanceBuilder(String message, Throwable cause) {
        return new ThrowableBuilder(message, cause);
    }

    public static ThrowableBuilder createInstanceBuilder(Throwable cause) {
        return new ThrowableBuilder(cause == null ? null : cause.toString(), cause);
    }

    public static Throwable getCause(Throwable throwable) {
        if (throwable instanceof ActivationException) {
            return ((ActivationException)throwable).detail;
        }
        if (throwable instanceof ClassNotFoundException) {
            return ((ClassNotFoundException)throwable).getException();
        }
        if (throwable instanceof ExceptionInInitializerError) {
            return ((ExceptionInInitializerError)throwable).getException();
        }
        if (throwable instanceof InvocationTargetException) {
            return ((InvocationTargetException)throwable).getTargetException();
        }
        if (throwable instanceof PrinterIOException) {
            return ((PrinterIOException)throwable).getIOException();
        }
        if (throwable instanceof PrivilegedActionException) {
            return ((PrivilegedActionException)throwable).getException();
        }
        if (throwable instanceof RemoteException) {
            return ((RemoteException)throwable).detail;
        }
        if (throwable instanceof ServerCloneException) {
            return ((ServerCloneException)throwable).detail;
        }
        if (throwable instanceof UndeclaredThrowableException) {
            return ((UndeclaredThrowableException)throwable).getUndeclaredThrowable();
        }
        if (throwable instanceof WriteAbortedException) {
            return ((WriteAbortedException)throwable).detail;
        }
        if (throwable instanceof NamingException) {
            return ((NamingException)throwable).getRootCause();
        }
        Throwable result = causeTable.lookup(throwable);
        return result == NULL ? null : result;
    }

    public static Throwable initCause(Throwable throwable, Throwable cause) {
        if (throwable instanceof ActivationException || throwable instanceof ClassNotFoundException || throwable instanceof ExceptionInInitializerError || throwable instanceof InvocationTargetException || throwable instanceof PrinterIOException || throwable instanceof PrivilegedActionException || throwable instanceof RemoteException || throwable instanceof ServerCloneException || throwable instanceof UndeclaredThrowableException || throwable instanceof WriteAbortedException) {
            throw new IllegalStateException();
        }
        if (throwable instanceof NamingException) {
            _Throwable.saveCause(throwable, null);
            ((NamingException)throwable).setRootCause(cause);
        } else {
            _Throwable.saveCause(throwable, cause);
        }
        return throwable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveCause(Throwable throwable, Throwable cause) {
        Throwable throwable2 = throwable;
        synchronized (throwable2) {
            if (causeTable.lookup(throwable) != null) {
                throw new IllegalStateException();
            }
            if (throwable == cause) {
                throw new IllegalArgumentException();
            }
            causeTable.putIfAbsent(throwable, cause == null ? NULL : cause);
        }
    }

    public static StackTraceElement_[] getStackTrace(Throwable throwable) {
        ArrayList<StackTraceElement_> result = new ArrayList<StackTraceElement_>();
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        BufferedReader reader = new BufferedReader(new StringReader(writer.toString()));
        try {
            String s;
            while ((s = reader.readLine()) != null) {
                StackTraceElement_ element;
                StackTraceElement_ stackTraceElement_ = element = !s.startsWith(TAB_AT_SPACE) ? null : StackTraceElement_.valueOf(s.substring(TAB_AT_SPACE.length()));
                if (element != null) {
                    result.add(element);
                    continue;
                }
                if (result.isEmpty()) continue;
                break;
            }
        }
        catch (IOException e) {
            throw new Error(e.getMessage());
        }
        return result.toArray(new StackTraceElement_[result.size()]);
    }

    public static class ThrowableBuilder {
        private final String message;
        private final Throwable cause;

        protected ThrowableBuilder(String message, Throwable cause) {
            this.message = message;
            this.cause = cause;
        }

        public String argument1() {
            return this.message;
        }

        public void initialize(Throwable throwable) {
            _Throwable.initCause(throwable, this.cause);
        }
    }
}

