/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.runtime13.impl;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.retrotranslator.runtime13.asm.AnnotationVisitor;
import net.sf.retrotranslator.runtime13.asm.Type;
import net.sf.retrotranslator.runtime13.impl.AnnotationArray;
import net.sf.retrotranslator.runtime13.impl.AnnotationHandler;
import net.sf.retrotranslator.runtime13.impl.AnnotationValue;
import net.sf.retrotranslator.runtime13.impl.ClassDescriptor;
import net.sf.retrotranslator.runtime13.impl.ClassTypeElement;
import net.sf.retrotranslator.runtime13.impl.EmptyVisitor;
import net.sf.retrotranslator.runtime13.impl.EnumValue;
import net.sf.retrotranslator.runtime13.impl.GenericArrayTypeImpl;
import net.sf.retrotranslator.runtime13.impl.LazyList;
import net.sf.retrotranslator.runtime13.impl.LazyValue;
import net.sf.retrotranslator.runtime13.impl.MethodDescriptor;
import net.sf.retrotranslator.runtime13.impl.ParameterizedTypeImpl;
import net.sf.retrotranslator.runtime13.impl.RuntimeTools;
import net.sf.retrotranslator.runtime13.impl.TypeArgument;
import net.sf.retrotranslator.runtime13.impl.TypeDescriptor;
import net.sf.retrotranslator.runtime13.impl.WildcardTypeImpl;
import net.sf.retrotranslator.runtime13.v15.java.lang.Enum_;
import net.sf.retrotranslator.runtime13.v15.java.lang.TypeNotPresentException_;
import net.sf.retrotranslator.runtime13.v15.java.lang.annotation.AnnotationTypeMismatchException_;
import net.sf.retrotranslator.runtime13.v15.java.lang.annotation.Annotation_;
import net.sf.retrotranslator.runtime13.v15.java.lang.annotation.IncompleteAnnotationException_;
import net.sf.retrotranslator.runtime13.v15.java.lang.reflect.TypeVariable_;
import net.sf.retrotranslator.runtime13.v15.java.lang.reflect.Type_;

/*
 * This class specifies class file version 47.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotatedElementDescriptor
extends EmptyVisitor {
    private static final Annotation_[] EMPTY = new Annotation_[0];
    protected static final EmptyVisitor EMPTY_VISITOR = new EmptyVisitor();
    protected int access;
    private LazyList<AnnotationValue, Annotation_> declaredAnnotations = new LazyList<AnnotationValue, Annotation_>(){

        @Override
        protected Annotation_ resolve(AnnotationValue input) {
            return AnnotatedElementDescriptor.this.createAnnotation(input);
        }

        protected Annotation_[] newArray(int size) {
            return new Annotation_[size];
        }

        @Override
        protected /* synthetic */ Object[] newArray(int x0) {
            return this.newArray(x0);
        }

        @Override
        protected /* synthetic */ Object resolve(Object x0) {
            return this.resolve((AnnotationValue)x0);
        }
    };
    private LazyValue<LazyList<AnnotationValue, Annotation_>, Annotation_[]> annotations = new LazyValue<LazyList<AnnotationValue, Annotation_>, Annotation_[]>(this.declaredAnnotations){

        @Override
        protected Annotation_[] resolve(LazyList<AnnotationValue, Annotation_> input) {
            return AnnotatedElementDescriptor.this.createAnnotations(input.getLive());
        }

        @Override
        protected /* synthetic */ Object resolve(Object x0) {
            return this.resolve((LazyList)x0);
        }
    };
    static /* synthetic */ Class class$net$sf$retrotranslator$runtime13$v15$java$lang$annotation$Annotation_;
    static /* synthetic */ Class class$java$lang$String;

    public boolean isAccess(int mask) {
        return (this.access & mask) != 0;
    }

    public boolean isAnnotationPresent(Class annotationType) {
        for (Annotation_ annotation : this.annotations.get()) {
            if (!annotationType.isInstance(annotation)) continue;
            return true;
        }
        return false;
    }

    public Annotation_ getAnnotation(Class annotationType) {
        for (Annotation_ annotation : this.annotations.get()) {
            if (!annotationType.isInstance(annotation)) continue;
            return annotation;
        }
        return null;
    }

    public Annotation_[] getAnnotations() {
        Annotation_[] result = this.annotations.get();
        return result.length == 0 ? result : (Annotation_[])result.clone();
    }

    public Annotation_[] getDeclaredAnnotations() {
        return this.declaredAnnotations.getClone();
    }

    public abstract String getName();

    public abstract String getDesc();

    public abstract ClassDescriptor getClassDescriptor();

    public abstract String getInfo();

    protected abstract TypeVariable_ findTypeVariable(String var1);

    protected abstract Annotation_[] createAnnotations(Annotation_[] var1);

    protected Annotation_[] createAnnotations(List<AnnotationValue> values) {
        if (values == null) {
            return EMPTY;
        }
        Annotation_[] result = new Annotation_[values.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.createAnnotation(values.get(i));
        }
        return result;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (!visible) {
            return EMPTY_VISITOR;
        }
        AnnotationValue value = new AnnotationValue(desc);
        this.declaredAnnotations.add(value);
        return value;
    }

    private ClassLoader getClassLoader() {
        return this.getClassDescriptor().getTarget().getClassLoader();
    }

    protected Class getClassByInternalName(String name) {
        name = RuntimeTools.getDisplayClassName(name);
        try {
            return Class.forName(name, false, this.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new TypeNotPresentException_(name, e);
        }
    }

    protected Class getClassByType(Type type) {
        Class baseClass = RuntimeTools.getBaseClass(type);
        if (baseClass != null) {
            return baseClass;
        }
        return this.getClassByInternalName(type.getSort() == 9 ? type.getDescriptor() : type.getInternalName());
    }

    private Class getClassByDesc(String desc) {
        return this.getClassByType(Type.getType(desc));
    }

    public Object[] createTypes(List<TypeDescriptor> descriptors) {
        if (descriptors == null) {
            return null;
        }
        Object[] result = new Object[descriptors.size()];
        Iterator<TypeDescriptor> iterator = descriptors.iterator();
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.createType(iterator.next());
        }
        return result;
    }

    public Object createType(TypeDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        if (descriptor.arrayType != null) {
            return new GenericArrayTypeImpl(this.createType(descriptor.arrayType));
        }
        if (descriptor.typeVariable != null) {
            return this.findTypeVariable(descriptor.typeVariable);
        }
        LinkedList<ClassTypeElement> elements = descriptor.elements;
        if (elements != null) {
            return this.createClassType(elements.toArray(new ClassTypeElement[elements.size()]));
        }
        return RuntimeTools.getBaseClass(descriptor.baseType);
    }

    private Object createClassType(ClassTypeElement[] typeElements) {
        String className = null;
        for (ClassTypeElement typeElement : typeElements) {
            className = new StringBuffer().append(className == null ? "" : new StringBuffer().append(className).append("$").toString()).append(typeElement.getName()).toString();
        }
        /*
         * This class specifies class file version 47.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Element {
            Class rawType;
            List<TypeArgument> arguments;

            public Element(Class rawType, List<TypeArgument> arguments) {
                this.rawType = rawType;
                this.arguments = arguments;
            }
        }
        LinkedList<Element> elements = new LinkedList<Element>();
        Class<?> currentClass = this.getClassByInternalName(className);
        for (int i = typeElements.length - 1; i >= 0; --i) {
            elements.addFirst(new Element(currentClass, typeElements[i].getArguments()));
            currentClass = currentClass.getDeclaringClass();
            if (currentClass == null) break;
        }
        Object result = ((Element)elements.getFirst()).arguments.isEmpty() ? null : currentClass;
        for (Element element : elements) {
            result = result == null && element.arguments.isEmpty() ? element.rawType : new ParameterizedTypeImpl(this.createArguments(element.arguments), element.rawType, result);
        }
        return result;
    }

    private Object[] createArguments(List<TypeArgument> arguments) {
        Object[] result = new Object[arguments.size()];
        Iterator<TypeArgument> iterator = arguments.iterator();
        for (int i = 0; i < result.length; ++i) {
            TypeArgument argument = iterator.next();
            result[i] = argument.wildcard == '=' ? this.createType(argument.descriptor) : new WildcardTypeImpl(argument.wildcard == '+', this.getLazyType(argument.descriptor));
        }
        return result;
    }

    private Annotation_ createAnnotation(AnnotationValue annotationValue) {
        Class[] interfaces;
        ClassLoader classLoader;
        Class annotationType = this.getClassByDesc(annotationValue.getDesc());
        StringBuffer buffer = new StringBuffer("@").append(annotationType.getName()).append('(');
        HashMap<String, Object> values = new HashMap<String, Object>();
        boolean isFirst = true;
        for (MethodDescriptor descriptor : ClassDescriptor.getInstance(annotationType).getMethodDescriptors()) {
            Object resolvedValue;
            if (descriptor.getName().equals("<clinit>")) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                buffer.append(", ");
            }
            String elementName = descriptor.getName();
            Object elementValue = annotationValue.getElement(elementName);
            Object object = resolvedValue = elementValue == null ? descriptor.getDefaultValue() : this.resolveValue(elementValue, descriptor.getReturnType(), descriptor);
            if (resolvedValue == null) {
                throw new IncompleteAnnotationException_(annotationType, elementName);
            }
            values.put(elementName, resolvedValue);
            buffer.append(elementName).append('=');
            AnnotatedElementDescriptor.append(buffer, resolvedValue);
        }
        buffer.append(")");
        Class<?> clazz = class$net$sf$retrotranslator$runtime13$v15$java$lang$annotation$Annotation_;
        if (clazz == null) {
            clazz = class$net$sf$retrotranslator$runtime13$v15$java$lang$annotation$Annotation_ = new Annotation_[0].getClass().getComponentType();
        }
        if (clazz.isAssignableFrom(annotationType)) {
            classLoader = this.getClassLoader();
            interfaces = new Class[]{annotationType};
        } else {
            classLoader = this.getProxyClassLoader(annotationType);
            Class[] classArray = new Class[2];
            classArray[0] = annotationType;
            Class<?> clazz2 = class$net$sf$retrotranslator$runtime13$v15$java$lang$annotation$Annotation_;
            if (clazz2 == null) {
                clazz2 = class$net$sf$retrotranslator$runtime13$v15$java$lang$annotation$Annotation_ = new Annotation_[0].getClass().getComponentType();
            }
            classArray[1] = clazz2;
            interfaces = classArray;
        }
        return (Annotation_)Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)new AnnotationHandler(annotationType, buffer.toString(), values));
    }

    private ClassLoader getProxyClassLoader(Class annotationType) {
        try {
            Class<?> clazz;
            Class<?> clazz2 = class$net$sf$retrotranslator$runtime13$v15$java$lang$annotation$Annotation_;
            if (clazz2 == null) {
                clazz2 = class$net$sf$retrotranslator$runtime13$v15$java$lang$annotation$Annotation_ = new Annotation_[0].getClass().getComponentType();
            }
            if ((clazz = class$net$sf$retrotranslator$runtime13$v15$java$lang$annotation$Annotation_) == null) {
                clazz = class$net$sf$retrotranslator$runtime13$v15$java$lang$annotation$Annotation_ = new Annotation_[0].getClass().getComponentType();
            }
            if (clazz2 == Class.forName(clazz.getName(), false, this.getClassLoader())) {
                return this.getClassLoader();
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            String string = annotationType.getName();
            Class<?> clazz = class$net$sf$retrotranslator$runtime13$v15$java$lang$annotation$Annotation_;
            if (clazz == null) {
                clazz = class$net$sf$retrotranslator$runtime13$v15$java$lang$annotation$Annotation_ = new Annotation_[0].getClass().getComponentType();
            }
            if (annotationType == Class.forName(string, false, clazz.getClassLoader())) {
                Class<?> clazz3 = class$net$sf$retrotranslator$runtime13$v15$java$lang$annotation$Annotation_;
                if (clazz3 == null) {
                    clazz3 = class$net$sf$retrotranslator$runtime13$v15$java$lang$annotation$Annotation_ = new Annotation_[0].getClass().getComponentType();
                }
                return clazz3.getClassLoader();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return this.getClassLoader();
    }

    protected Object resolveValue(Object value, Class type, MethodDescriptor descriptor) {
        if (value == null) {
            return null;
        }
        if (value instanceof Type) {
            value = this.getClassByType((Type)value);
        } else if (value instanceof EnumValue) {
            EnumValue enumValue = (EnumValue)value;
            value = this.getEnumValue(this.getClassByDesc(enumValue.getDescriptor()), enumValue.getValue());
        } else if (value instanceof AnnotationValue) {
            value = this.createAnnotation((AnnotationValue)value);
        } else if (value instanceof AnnotationArray) {
            AnnotationArray array = (AnnotationArray)value;
            Class<?> componentType = type.getComponentType();
            List<Object> values = array.getValues();
            value = Array.newInstance(componentType, values.size());
            for (int i = Array.getLength(value) - 1; i >= 0; --i) {
                Array.set(value, i, this.resolveValue(values.get(i), componentType, descriptor));
            }
        }
        if (!type.isPrimitive() && !type.isInstance(value)) {
            throw new AnnotationTypeMismatchException_(descriptor.getMethod(), type.getName());
        }
        return value;
    }

    private Object getEnumValue(Class enumType, String name) {
        try {
            return Enum_.valueOf(enumType, name);
        }
        catch (IllegalArgumentException e) {
            try {
                Class[] classArray = new Class[1];
                Class<?> clazz = class$java$lang$String;
                if (clazz == null) {
                    clazz = class$java$lang$String = new String[0].getClass().getComponentType();
                }
                classArray[0] = clazz;
                return enumType.getMethod("valueOf", classArray).invoke(null, name);
            }
            catch (Exception ex) {
                throw e;
            }
        }
    }

    private static void append(StringBuffer buffer, Object value) {
        if (value.getClass().isArray()) {
            buffer.append('[');
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                AnnotatedElementDescriptor.append(buffer, Array.get(value, i));
            }
            buffer.append(']');
        } else {
            buffer.append(value);
        }
    }

    protected LazyValue<TypeDescriptor, Object> getLazyType(TypeDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        return new LazyValue<TypeDescriptor, Type_>(descriptor){

            @Override
            protected Object resolve(TypeDescriptor input) {
                return AnnotatedElementDescriptor.this.createType(input);
            }

            @Override
            protected /* synthetic */ Object resolve(Object x0) {
                return this.resolve((TypeDescriptor)x0);
            }
        };
    }

    protected LazyList<TypeDescriptor, Object> getLazyList() {
        return new LazyList<TypeDescriptor, Type_>(){

            @Override
            protected Object resolve(TypeDescriptor descriptor) {
                return AnnotatedElementDescriptor.this.createType(descriptor);
            }

            @Override
            protected Object[] newArray(int size) {
                return new Object[size];
            }

            @Override
            protected /* synthetic */ Object resolve(Object x0) {
                return this.resolve((TypeDescriptor)x0);
            }
        };
    }
}

