/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.runtime13.format;

import net.sf.retrotranslator.runtime13.format.Conversion;
import net.sf.retrotranslator.runtime13.format.FormatContext;
import net.sf.retrotranslator.runtime13.v14.java.lang._Boolean;

abstract class GeneralConversion
extends Conversion {
    GeneralConversion() {
    }

    protected void printf(FormatContext context, Object argument) {
        context.assertNoFlag('#');
        context.checkWidth();
        context.writeRestricted(String.valueOf(argument));
    }

    public static class StringConversion
    extends GeneralConversion {
        public void format(FormatContext context) {
            if (!context.writeFormattable()) {
                context.checkWidth();
                context.writeRestricted(String.valueOf(context.getArgument()));
            }
        }
    }

    public static class HashConversion
    extends GeneralConversion {
        public void format(FormatContext context) {
            Object argument = context.getArgument();
            this.printf(context, argument == null ? null : Integer.toHexString(argument.hashCode()));
        }
    }

    public static class BooleanConversion
    extends GeneralConversion {
        public void format(FormatContext context) {
            Object argument = context.getArgument();
            this.printf(context, argument instanceof Boolean ? argument : _Boolean.valueOf(argument != null));
        }
    }
}

