/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.sf.retrotranslator.runtime.asm.ClassReader;
import net.sf.retrotranslator.runtime.impl.RuntimeTools;
import net.sf.retrotranslator.runtime.java.lang._String;
import net.sf.retrotranslator.transformer.ClassVersion;
import net.sf.retrotranslator.transformer.Level;
import net.sf.retrotranslator.transformer.SystemLogger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TargetEnvironment {
    private static byte[] NO_CONTENT = new byte[0];
    private final ClassLoader classLoader;
    private final SystemLogger logger;
    private final boolean contextual;
    private final List<Entry> entries = new Vector<Entry>();
    private SoftReference<Map<String, byte[]>> cacheReference;

    public TargetEnvironment(ClassLoader classLoader, SystemLogger logger, boolean contextual) {
        this.classLoader = classLoader;
        this.logger = logger;
        this.contextual = contextual;
    }

    public void appendPath(File element) {
        if (!element.exists()) {
            throw new RuntimeException(new StringBuffer().append(element.getPath()).append(" not found.").toString());
        }
        this.entries.add(element.isDirectory() ? new DirectoryEntry(element) : new ZipFileEntry(element));
    }

    public ClassReader getClassReader(String name) throws ClassNotFoundException {
        byte[] content = this.getClassContent(name);
        if (content == null) {
            throw new ClassNotFoundException(name);
        }
        return new ClassReader(content);
    }

    public ClassReader findClassReader(String className) {
        try {
            return this.getClassReader(className);
        }
        catch (ClassNotFoundException e) {
            this.logger.logForFile(Level.VERBOSE, new StringBuffer().append("Cannot find ").append(RuntimeTools.getDisplayClassName(className)).toString());
            return null;
        }
    }

    public byte[] getClassContent(String name) {
        Map<String, byte[]> cache = this.getCache();
        byte[] content = cache.get(name);
        if (content != null) {
            return (byte[])(content != NO_CONTENT ? content : null);
        }
        List<byte[]> resources = this.getResources(new StringBuffer().append(name).append(".class").toString(), 1);
        content = resources.isEmpty() ? null : resources.get(0);
        cache.put(name, content != null ? content : NO_CONTENT);
        return content;
    }

    private synchronized Map<String, byte[]> getCache() {
        Map<String, byte[]> cache;
        Map<String, byte[]> map = cache = this.cacheReference == null ? null : this.cacheReference.get();
        if (cache == null) {
            cache = new Hashtable<String, byte[]>();
            this.cacheReference = new SoftReference<Map<String, byte[]>>(cache);
        }
        return cache;
    }

    public void close() {
        for (Entry entry : this.entries) {
            try {
                entry.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Collection<String> readRegistry(String name, ClassVersion target) {
        try {
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            String resourceName = new StringBuffer().append("net/sf/retrotranslator/registry/").append(name).append(_String.replace(target.getName(), ".", "")).append(".properties").toString();
            for (byte[] resource : this.getResources(resourceName, Integer.MAX_VALUE)) {
                String line;
                String content = new String(resource, "UTF-8");
                BufferedReader reader = new BufferedReader(new StringReader(content));
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0) continue;
                    result.add(line);
                }
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<byte[]> getResources(final String name, final int maxCount) {
        final ArrayList<byte[]> result = new ArrayList<byte[]>();
        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ResourceLoader {
            ResourceLoader() {
            }

            boolean addResource(InputStream stream) {
                if (stream == null) {
                    return false;
                }
                result.add(RuntimeTools.readAndClose(stream));
                return result.size() >= maxCount;
            }

            boolean addResources(ClassLoader loader) {
                if (loader == null) {
                    return false;
                }
                try {
                    Enumeration<URL> resources = loader.getResources(name);
                    while (resources.hasMoreElements()) {
                        URL url = resources.nextElement();
                        if (!this.addResource(url.openStream())) continue;
                        return true;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return false;
            }
        }
        ResourceLoader loader = new ResourceLoader();
        for (Entry entry : this.entries) {
            InputStream stream = entry.getResourceAsStream(name);
            if (!loader.addResource(stream)) continue;
            return result;
        }
        if (loader.addResources(this.classLoader)) {
            return result;
        }
        if (this.contextual) {
            loader.addResources(Thread.currentThread().getContextClassLoader());
        }
        return result;
    }

    private static class ZipFileEntry
    implements Entry {
        private final File file;
        private ZipFile zipFile;

        public ZipFileEntry(File file) {
            this.file = file;
        }

        public InputStream getResourceAsStream(String name) {
            if (this.zipFile == null) {
                this.openZipFile();
            }
            try {
                ZipEntry entry = this.zipFile.getEntry(name);
                return entry == null ? null : this.zipFile.getInputStream(entry);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private void openZipFile() {
            try {
                this.zipFile = new ZipFile(this.file);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot open zip file: " + this.file.getAbsolutePath(), e);
            }
        }

        public void close() {
            try {
                if (this.zipFile != null) {
                    this.zipFile.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class DirectoryEntry
    implements Entry {
        private File directory;

        public DirectoryEntry(File directory) {
            this.directory = directory;
        }

        public InputStream getResourceAsStream(String name) {
            try {
                return new FileInputStream(new File(this.directory, name));
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }

        public void close() {
        }
    }

    private static interface Entry {
        public InputStream getResourceAsStream(String var1);

        public void close();
    }
}

