/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.retrotranslator.transformer.AbstractLogger;
import net.sf.retrotranslator.transformer.ClassTransformer;
import net.sf.retrotranslator.transformer.ClassVersion;
import net.sf.retrotranslator.transformer.EmbeddingConverter;
import net.sf.retrotranslator.transformer.FileContainer;
import net.sf.retrotranslator.transformer.FileEntry;
import net.sf.retrotranslator.transformer.FileTranslator;
import net.sf.retrotranslator.transformer.FolderFileContainer;
import net.sf.retrotranslator.transformer.JarFileContainer;
import net.sf.retrotranslator.transformer.Level;
import net.sf.retrotranslator.transformer.Message;
import net.sf.retrotranslator.transformer.MessageLogger;
import net.sf.retrotranslator.transformer.OperationMode;
import net.sf.retrotranslator.transformer.ReferenceVerifyingVisitor;
import net.sf.retrotranslator.transformer.ReflectionMode;
import net.sf.retrotranslator.transformer.ReplacementLocatorFactory;
import net.sf.retrotranslator.transformer.SourceMask;
import net.sf.retrotranslator.transformer.SystemLogger;
import net.sf.retrotranslator.transformer.TargetEnvironment;
import net.sf.retrotranslator.transformer.TextFileTransformer;
import net.sf.retrotranslator.transformer.TransformerTools;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Retrotranslator {
    private LinkedList<FileContainer> src = new LinkedList();
    private FileContainer dest;
    private boolean stripsign;
    private boolean stripannot;
    private boolean retainapi;
    private boolean retainflags;
    private boolean verbose;
    private boolean lazy;
    private boolean advanced;
    private boolean verify;
    private boolean uptodatecheck;
    private boolean smart;
    private boolean syncvolatile;
    private boolean syncfinal;
    private boolean keepclasslit;
    private ReflectionMode reflectionMode = ReflectionMode.NORMAL;
    private List<File> classpath = new ArrayList<File>();
    private MessageLogger logger;
    private SourceMask sourceMask = new SourceMask(null);
    private String embed;
    private String support;
    private String backport;
    private ClassVersion target = ClassVersion.VERSION_14;
    private ClassLoader classLoader;
    static /* synthetic */ Class class$net$sf$retrotranslator$transformer$Retrotranslator;

    public void addSrcdir(File srcdir) {
        if (!srcdir.isDirectory()) {
            throw new IllegalArgumentException(new StringBuffer().append("Invalid srcdir: ").append(srcdir).toString());
        }
        this.src.add(new FolderFileContainer(srcdir));
    }

    public void addSrcjar(File srcjar) {
        if (!srcjar.isFile()) {
            throw new IllegalArgumentException(new StringBuffer().append("Invalid srcjar: ").append(srcjar).toString());
        }
        this.src.add(new JarFileContainer(srcjar));
    }

    public void addSourceFiles(File srcdir, List<String> fileNames) {
        if (!srcdir.isDirectory()) {
            throw new IllegalArgumentException(new StringBuffer().append("Invalid srcdir: ").append(srcdir).toString());
        }
        this.src.add(new FolderFileContainer(srcdir, fileNames));
    }

    public void setDestdir(File destdir) {
        if (!destdir.isDirectory()) {
            throw new IllegalArgumentException(new StringBuffer().append("Invalid destdir: ").append(destdir).toString());
        }
        if (this.dest != null) {
            throw new IllegalArgumentException("Destination already set.");
        }
        this.dest = new FolderFileContainer(destdir);
    }

    public void setDestjar(File destjar) {
        if (destjar.isDirectory()) {
            throw new IllegalArgumentException(new StringBuffer().append("Invalid destjar: ").append(destjar).toString());
        }
        if (this.dest != null) {
            throw new IllegalArgumentException("Destination already set.");
        }
        this.dest = new JarFileContainer(destjar);
    }

    public void setStripsign(boolean stripsign) {
        this.stripsign = stripsign;
    }

    public void setStripannot(boolean stripannot) {
        this.stripannot = stripannot;
    }

    public void setRetainapi(boolean retainapi) {
        this.retainapi = retainapi;
    }

    public void setRetainflags(boolean retainflags) {
        this.retainflags = retainflags;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public void setAdvanced(boolean advanced) {
        this.advanced = advanced;
    }

    public void setVerify(boolean verify) {
        this.verify = verify;
    }

    public void setUptodatecheck(boolean uptodatecheck) {
        this.uptodatecheck = uptodatecheck;
    }

    public void setSmart(boolean smart) {
        this.smart = smart;
    }

    public void setSyncvolatile(boolean syncvolatile) {
        this.syncvolatile = syncvolatile;
    }

    public void setSyncfinal(boolean syncfinal) {
        this.syncfinal = syncfinal;
    }

    public void setKeepclasslit(boolean keepclasslit) {
        this.keepclasslit = keepclasslit;
    }

    public void addClasspathElement(File classpathElement) {
        this.classpath.add(classpathElement);
    }

    public void addClasspath(String classpath) {
        StringTokenizer tokenizer = new StringTokenizer(classpath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            this.addClasspathElement(new File(tokenizer.nextToken()));
        }
    }

    public void setSrcmask(String srcmask) {
        this.sourceMask = new SourceMask(srcmask);
    }

    public void setReflection(String reflection) {
        this.reflectionMode = ReflectionMode.valueOf(reflection);
    }

    public void setEmbed(String embed) {
        this.embed = embed;
    }

    public void setSupport(String support) {
        this.support = support;
    }

    public void setBackport(String backport) {
        this.backport = backport;
    }

    public void setTarget(String target) {
        this.target = ClassVersion.valueOf(target);
    }

    public void setLogger(MessageLogger logger) {
        this.logger = logger;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public boolean run() {
        if (this.src.isEmpty()) {
            throw new IllegalArgumentException("No files to translate.");
        }
        SystemLogger systemLogger = new SystemLogger(this.getMessageLogger(), this.verbose);
        TargetEnvironment environment = this.createEnvironment(null, systemLogger);
        EmbeddingConverter converter = null;
        if (this.embed != null) {
            if (this.lazy) {
                throw new IllegalArgumentException("Embedding cannot be lazy.");
            }
            converter = new EmbeddingConverter(this.target, this.embed, environment, systemLogger);
        }
        OperationMode mode = new OperationMode(this.advanced, this.support, this.smart, this.target);
        ReplacementLocatorFactory factory = new ReplacementLocatorFactory(mode, this.retainapi, this.backport, environment);
        ClassTransformer classTransformer = new ClassTransformer(this.lazy, this.stripsign, this.stripannot, this.retainflags, this.syncvolatile, this.syncfinal, this.keepclasslit, this.reflectionMode, systemLogger, converter, factory);
        TextFileTransformer fileTransformer = new TextFileTransformer(factory, converter);
        FileTranslator translator = new FileTranslator(classTransformer, fileTransformer, converter, systemLogger, this.sourceMask, this.uptodatecheck, mode);
        boolean modified = false;
        for (FileContainer container : this.src) {
            modified |= translator.transform(container, this.dest != null ? this.dest : container);
        }
        if (converter != null && this.dest != null) {
            converter.embed(this.dest, classTransformer);
        }
        if (this.dest != null) {
            this.dest.flush(systemLogger);
        }
        if (!this.verify) {
            return systemLogger.isReliable();
        }
        if (!modified) {
            this.logger.log(new Message(Level.INFO, "Skipped verification of up-to-date file(s)."));
            return systemLogger.isReliable();
        }
        this.verify(systemLogger);
        return systemLogger.isReliable();
    }

    private TargetEnvironment createEnvironment(FileContainer destination, SystemLogger logger) {
        ClassLoader loader = this.classLoader;
        if (loader == null && this.classpath.isEmpty()) {
            loader = TransformerTools.getDefaultClassLoader();
        }
        TargetEnvironment environment = new TargetEnvironment(loader, logger, false);
        if (destination != null) {
            environment.appendPath(destination.getLocation());
        } else {
            for (FileContainer container : this.src) {
                environment.appendPath(container.getLocation());
            }
        }
        for (File file : this.classpath) {
            environment.appendPath(file);
        }
        return environment;
    }

    private MessageLogger getMessageLogger() {
        if (this.logger != null) {
            return this.logger;
        }
        return new AbstractLogger(){

            protected void log(String text, Level level) {
                System.out.println(text);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verify(SystemLogger systemLogger) {
        TargetEnvironment environment = this.createEnvironment(this.dest, systemLogger);
        try {
            if (this.dest != null) {
                this.verify(environment, this.dest, systemLogger);
            } else {
                for (FileContainer container : this.src) {
                    this.verify(environment, container, systemLogger);
                }
            }
        }
        finally {
            environment.close();
        }
    }

    private void verify(TargetEnvironment environment, FileContainer container, SystemLogger systemLogger) {
        systemLogger.log(new Message(Level.INFO, new StringBuffer().append("Verifying ").append(container.getFileCount()).append(" file(s) in ").append(container).append(".").toString()));
        int warningCount = 0;
        int fileCount = 0;
        for (FileEntry fileEntry : container.getEntries()) {
            byte[] content;
            if (!this.sourceMask.matches(fileEntry.getName()) || this.lazy && !fileEntry.isModified() || !TransformerTools.isClassFile(content = fileEntry.getContent())) continue;
            systemLogger.setFile(container.getLocation(), fileEntry.getName());
            systemLogger.logForFile(Level.VERBOSE, "Verification");
            ++fileCount;
            warningCount += new ReferenceVerifyingVisitor(this.target, environment, systemLogger).verify(content);
            systemLogger.setFile(null, null);
        }
        systemLogger.log(new Message(Level.INFO, new StringBuffer().append("Verified ").append(fileCount).append(" file(s)").append(warningCount == 0 ? "." : new StringBuffer().append(" with ").append(warningCount).append(" warning(s).").toString()).toString()));
    }

    private boolean execute(String[] args) {
        int i = 0;
        while (i < args.length) {
            String string;
            if ((string = args[i++]).equals("-srcdir") && i < args.length) {
                this.addSrcdir(new File(args[i++]));
                continue;
            }
            if (string.equals("-srcjar") && i < args.length) {
                this.addSrcjar(new File(args[i++]));
                continue;
            }
            if (string.equals("-destdir") && i < args.length) {
                this.setDestdir(new File(args[i++]));
                continue;
            }
            if (string.equals("-destjar") && i < args.length) {
                this.setDestjar(new File(args[i++]));
                continue;
            }
            if (string.equals("-stripsign")) {
                this.setStripsign(true);
                continue;
            }
            if (string.equals("-stripannot")) {
                this.setStripannot(true);
                continue;
            }
            if (string.equals("-retainapi")) {
                this.setRetainapi(true);
                continue;
            }
            if (string.equals("-retainflags")) {
                this.setRetainflags(true);
                continue;
            }
            if (string.equals("-verbose")) {
                this.setVerbose(true);
                continue;
            }
            if (string.equals("-lazy")) {
                this.setLazy(true);
                continue;
            }
            if (string.equals("-advanced")) {
                this.setAdvanced(true);
                continue;
            }
            if (string.equals("-verify")) {
                this.setVerify(true);
                continue;
            }
            if (string.equals("-uptodatecheck")) {
                this.setUptodatecheck(true);
                continue;
            }
            if (string.equals("-smart")) {
                this.setSmart(true);
                continue;
            }
            if (string.equals("-syncvolatile")) {
                this.setSyncvolatile(true);
                continue;
            }
            if (string.equals("-syncfinal")) {
                this.setSyncfinal(true);
                continue;
            }
            if (string.equals("-keepclasslit")) {
                this.setKeepclasslit(true);
                continue;
            }
            if (string.equals("-classpath") && i < args.length) {
                this.addClasspath(args[i++]);
                continue;
            }
            if (string.equals("-srcmask") && i < args.length) {
                this.setSrcmask(args[i++]);
                continue;
            }
            if (string.equals("-embed") && i < args.length) {
                this.setEmbed(args[i++]);
                continue;
            }
            if (string.equals("-support") && i < args.length) {
                this.setSupport(args[i++]);
                continue;
            }
            if (string.equals("-backport") && i < args.length) {
                this.setBackport(args[i++]);
                continue;
            }
            if (string.equals("-target") && i < args.length) {
                this.setTarget(args[i++]);
                continue;
            }
            if (string.equals("-reflection") && i < args.length) {
                this.setReflection(args[i++]);
                continue;
            }
            throw new IllegalArgumentException(new StringBuffer().append("Unknown option: ").append(string).toString());
        }
        return this.run();
    }

    private static void printUsage() {
        String version;
        Class<?> clazz = class$net$sf$retrotranslator$transformer$Retrotranslator;
        if (clazz == null) {
            clazz = class$net$sf$retrotranslator$transformer$Retrotranslator = new Retrotranslator[0].getClass().getComponentType();
        }
        String suffix = (version = clazz.getPackage().getImplementationVersion()) == null ? "" : new StringBuffer().append("-").append(version).toString();
        System.out.println(new StringBuffer().append("Usage: java -jar retrotranslator-transformer").append(suffix).append(".jar [-srcdir <path> | -srcjar <file>] [-destdir <path> | -destjar <file>] [-support <features>]").append(" [-lazy] [-reflection <mode>] [-stripannot] [-stripsign] [-advanced] [-retainapi] [-retainflags]").append(" [-verify] [-uptodatecheck] [-target <version>] [-classpath <path>] [-srcmask <mask>] [-verbose]").append(" [-embed <package>] [-backport <packages>] [-smart] [-syncvolatile] [-syncfinal] [-keepclasslit]").toString());
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            Retrotranslator.printUsage();
            return;
        }
        try {
            if (!new Retrotranslator().execute(args)) {
                System.exit(2);
            }
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
            Retrotranslator.printUsage();
            System.exit(1);
        }
    }
}

