/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import net.sf.retrotranslator.runtime.asm.ClassAdapter;
import net.sf.retrotranslator.runtime.asm.ClassReader;
import net.sf.retrotranslator.runtime.asm.ClassVisitor;
import net.sf.retrotranslator.runtime.asm.MethodAdapter;
import net.sf.retrotranslator.runtime.asm.MethodVisitor;
import net.sf.retrotranslator.runtime.asm.Type;
import net.sf.retrotranslator.runtime.impl.EmptyVisitor;
import net.sf.retrotranslator.transformer.ReplacementLocator;
import net.sf.retrotranslator.transformer.TransformerTools;

class ObjectMethodsVisitor
extends ClassAdapter {
    private static final String OBJECT_NAME;
    private static ObjectMethod[] PUBLIC_METHODS;
    private static ObjectMethod[] PROTECTED_METHODS;
    private final ReplacementLocator locator;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public ObjectMethodsVisitor(ClassVisitor visitor, ReplacementLocator locator) {
        super(visitor);
        this.locator = locator;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor visitor = super.visitMethod(access, name, desc, signature, exceptions);
        return visitor == null ? null : new MethodAdapter(visitor){

            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                if (opcode == 182 && owner.charAt(0) == '[') {
                    this.mv.visitMethodInsn(opcode, OBJECT_NAME, name, desc);
                    return;
                }
                if (opcode == 185) {
                    ObjectMethod method;
                    int i$;
                    ObjectMethod[] arr$ = PUBLIC_METHODS;
                    int len$ = arr$.length;
                    for (i$ = 0; i$ < len$; ++i$) {
                        method = arr$[i$];
                        if (!method.equals(name, desc)) continue;
                        this.mv.visitMethodInsn(182, OBJECT_NAME, name, desc);
                        return;
                    }
                    arr$ = PROTECTED_METHODS;
                    len$ = arr$.length;
                    for (i$ = 0; i$ < len$; ++i$) {
                        String methodOwner;
                        method = arr$[i$];
                        if (!method.equals(name, desc) || (methodOwner = ObjectMethodsVisitor.this.findMethodOwner(owner, method)) == null) continue;
                        this.mv.visitMethodInsn(opcode, methodOwner, name, desc);
                        return;
                    }
                }
                super.visitMethodInsn(opcode, owner, name, desc);
            }
        };
    }

    private String findMethodOwner(String className, ObjectMethod method) {
        String uniqueTypeName = this.locator.getUniqueTypeName(className);
        ClassReader reader = this.locator.getEnvironment().findClassReader(uniqueTypeName);
        if (reader == null) {
            return null;
        }
        MethodSearchingVisitor visitor = new MethodSearchingVisitor(method);
        reader.accept(visitor, true);
        if (visitor.methodFound) {
            return uniqueTypeName;
        }
        if (visitor.interfaces != null) {
            String[] arr$ = visitor.interfaces;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String anInterface = arr$[i$];
                String owner = this.findMethodOwner(anInterface, method);
                if (owner == null) continue;
                return owner;
            }
        }
        return null;
    }

    static {
        Class<?> clazz = class$java$lang$Object;
        if (clazz == null) {
            clazz = class$java$lang$Object = new Object[0].getClass().getComponentType();
        }
        OBJECT_NAME = Type.getInternalName(clazz);
        ObjectMethod[] objectMethodArray = new ObjectMethod[3];
        Class[] classArray = new Class[1];
        Class<?> clazz2 = class$java$lang$Object;
        if (clazz2 == null) {
            clazz2 = class$java$lang$Object = new Object[0].getClass().getComponentType();
        }
        classArray[0] = clazz2;
        objectMethodArray[0] = new ObjectMethod(Boolean.TYPE, "equals", classArray);
        objectMethodArray[1] = new ObjectMethod(Integer.TYPE, "hashCode", new Class[0]);
        Class<?> clazz3 = class$java$lang$String;
        if (clazz3 == null) {
            clazz3 = class$java$lang$String = new String[0].getClass().getComponentType();
        }
        objectMethodArray[2] = new ObjectMethod(clazz3, "toString", new Class[0]);
        PUBLIC_METHODS = objectMethodArray;
        ObjectMethod[] objectMethodArray2 = new ObjectMethod[2];
        Class<?> clazz4 = class$java$lang$Object;
        if (clazz4 == null) {
            clazz4 = class$java$lang$Object = new Object[0].getClass().getComponentType();
        }
        objectMethodArray2[0] = new ObjectMethod(clazz4, "clone", new Class[0]);
        objectMethodArray2[1] = new ObjectMethod(Void.TYPE, "finalize", new Class[0]);
        PROTECTED_METHODS = objectMethodArray2;
    }

    private static class ObjectMethod {
        public final String name;
        public final String desc;

        public ObjectMethod(Class returnType, String name, Class[] parameterTypes) {
            this.name = name;
            this.desc = TransformerTools.descriptor(returnType, parameterTypes);
        }

        public boolean equals(String name, String desc) {
            return name.equals(this.name) && desc.equals(this.desc);
        }
    }

    private static class MethodSearchingVisitor
    extends EmptyVisitor {
        private final ObjectMethod method;
        public boolean methodFound;
        public String[] interfaces;

        public MethodSearchingVisitor(ObjectMethod method) {
            this.method = method;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.interfaces = interfaces;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (this.method.equals(name, desc)) {
                this.methodFound = true;
            }
            return null;
        }
    }
}

