/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import net.sf.retrotranslator.runtime.asm.ClassAdapter;
import net.sf.retrotranslator.runtime.asm.ClassReader;
import net.sf.retrotranslator.runtime.asm.ClassVisitor;
import net.sf.retrotranslator.runtime.asm.FieldVisitor;
import net.sf.retrotranslator.runtime.asm.MethodAdapter;
import net.sf.retrotranslator.runtime.asm.MethodVisitor;
import net.sf.retrotranslator.runtime.impl.EmptyVisitor;
import net.sf.retrotranslator.transformer.ReplacementLocator;

class InheritedConstantVisitor
extends ClassAdapter {
    private final ReplacementLocator locator;

    public InheritedConstantVisitor(ClassVisitor visitor, ReplacementLocator locator) {
        super(visitor);
        this.locator = locator;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor visitor = super.visitMethod(access, name, desc, signature, exceptions);
        return visitor == null ? null : new MethodAdapter(visitor){

            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                super.visitFieldInsn(opcode, InheritedConstantVisitor.this.fixFieldOwner(opcode, owner, name), name, desc);
            }
        };
    }

    private String fixFieldOwner(int opcode, String owner, String name) {
        String fieldOwner;
        if (opcode == 178 && (fieldOwner = this.findFieldOwner(owner, name)) != null) {
            return fieldOwner;
        }
        return owner;
    }

    private String findFieldOwner(String className, String fieldName) {
        String uniqueTypeName = this.locator.getUniqueTypeName(className);
        ClassReader classReader = this.locator.getEnvironment().findClassReader(uniqueTypeName);
        if (classReader == null) {
            return null;
        }
        FieldSearchingVisitor visitor = new FieldSearchingVisitor(fieldName);
        classReader.accept(visitor, true);
        if (visitor.fieldFound) {
            return (visitor.access & 0x200) != 0 ? uniqueTypeName : null;
        }
        if (visitor.interfaces != null) {
            String[] arr$ = visitor.interfaces;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String interfaceName = arr$[i$];
                String result = this.findFieldOwner(interfaceName, fieldName);
                if (result == null) continue;
                return result;
            }
        }
        return visitor.superName != null ? this.findFieldOwner(visitor.superName, fieldName) : null;
    }

    private class FieldSearchingVisitor
    extends EmptyVisitor {
        private final String fieldName;
        public boolean fieldFound;
        public int access;
        public String superName;
        public String[] interfaces;

        public FieldSearchingVisitor(String fieldName) {
            this.fieldName = fieldName;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.access = access;
            this.superName = superName;
            this.interfaces = interfaces;
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            if (name.equals(this.fieldName) && (access & 8) != 0) {
                this.fieldFound = true;
            }
            return null;
        }
    }
}

