/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import java.util.Iterator;
import net.sf.retrotranslator.transformer.ClassTransformer;
import net.sf.retrotranslator.transformer.EmbeddingConverter;
import net.sf.retrotranslator.transformer.FileContainer;
import net.sf.retrotranslator.transformer.FileEntry;
import net.sf.retrotranslator.transformer.Level;
import net.sf.retrotranslator.transformer.Message;
import net.sf.retrotranslator.transformer.OperationMode;
import net.sf.retrotranslator.transformer.SourceMask;
import net.sf.retrotranslator.transformer.SystemLogger;
import net.sf.retrotranslator.transformer.TextFileTransformer;
import net.sf.retrotranslator.transformer.TransformerTools;

class FileTranslator {
    private final ClassTransformer classTransformer;
    private final TextFileTransformer fileTransformer;
    private final EmbeddingConverter converter;
    private final SystemLogger logger;
    private final SourceMask mask;
    private final boolean uptodatecheck;
    private final OperationMode mode;
    private int countTransformed;

    public FileTranslator(ClassTransformer classTransformer, TextFileTransformer fileTransformer, EmbeddingConverter converter, SystemLogger logger, SourceMask mask, boolean uptodatecheck, OperationMode mode) {
        this.classTransformer = classTransformer;
        this.fileTransformer = fileTransformer;
        this.converter = converter;
        this.logger = logger;
        this.mask = mask;
        this.uptodatecheck = uptodatecheck;
        this.mode = mode;
    }

    public boolean transform(FileContainer source, FileContainer destination) {
        this.countTransformed = 0;
        this.logger.log(new Message(Level.INFO, "Processing " + source.getFileCount() + " file(s)" + (source == destination ? " in " + source : " from " + source + " to " + destination) + "."));
        if (this.uptodatecheck && source.lastModified() < destination.lastModified()) {
            this.logger.log(new Message(Level.INFO, "Skipped up-to-date file(s)."));
            return false;
        }
        Iterator<? extends FileEntry> i$ = source.getEntries().iterator();
        while (i$.hasNext()) {
            FileEntry entry = i$.next();
            this.transform(entry, source, destination);
        }
        this.logger.log(new Message(Level.INFO, "Transformed " + this.countTransformed + " file(s)."));
        if (this.converter != null && source == destination) {
            this.converter.embed(source, this.classTransformer);
        }
        source.flush(this.logger);
        return true;
    }

    private void transform(FileEntry entry, FileContainer source, FileContainer destination) {
        String name = entry.getName();
        String fixedName = this.mode.fixFileName(this.converter == null ? name : this.converter.convertFileName(name), entry);
        if (this.uptodatecheck && destination.containsUpToDate(fixedName, entry.lastModified())) {
            this.logger.logForFile(Level.VERBOSE, "Up to date");
            return;
        }
        if (this.mask.matches(name) || !name.equals(fixedName)) {
            boolean transformed;
            this.logger.setFile(source.getLocation(), name);
            this.logger.logForFile(Level.VERBOSE, "Transformation");
            byte[] sourceData = entry.getContent();
            byte[] resultData = TransformerTools.isClassFile(sourceData) ? this.classTransformer.transform(sourceData, 0, sourceData.length) : this.fileTransformer.transform(sourceData);
            boolean bl = transformed = sourceData != resultData || !fixedName.equals(name);
            if (transformed || source != destination) {
                if (!fixedName.equals(name)) {
                    destination.removeEntry(name);
                }
                destination.putEntry(fixedName, resultData, transformed);
            }
            if (transformed) {
                ++this.countTransformed;
            }
            this.logger.setFile(null, null);
        } else if (source != destination) {
            destination.putEntry(name, entry.getContent(), false);
        }
    }
}

