/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import java.util.Hashtable;
import java.util.Map;

class ClassVersion {
    private static Map<String, ClassVersion> VALUES = new Hashtable<String, ClassVersion>();
    public static final ClassVersion VERSION_11 = new ClassVersion("1.1", 45, 3);
    public static final ClassVersion VERSION_12 = new ClassVersion("1.2", 46, 0);
    public static final ClassVersion VERSION_13 = new ClassVersion("1.3", 47, 0);
    public static final ClassVersion VERSION_14 = new ClassVersion("1.4", 48, 0);
    public static final ClassVersion VERSION_15 = new ClassVersion("1.5", 49, 0);
    private String name;
    private int version;

    private ClassVersion(String name, int majorVersion, int minorVersion) {
        this.name = name;
        this.version = majorVersion | minorVersion << 16;
        VALUES.put(name, this);
    }

    public String getName() {
        return this.name;
    }

    public int getVersion() {
        return this.version;
    }

    public static ClassVersion valueOf(String name) {
        ClassVersion result = VALUES.get(name);
        if (result == null) {
            throw new IllegalArgumentException("Unsupported target: " + name);
        }
        return result;
    }

    public boolean isBefore(ClassVersion classVersion) {
        return this.isBefore(classVersion.getVersion());
    }

    public boolean isBefore(int other) {
        return (this.version & 0xFFFF) < (other & 0xFFFF);
    }
}

