/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.retrotranslator.transformer.ClassBackport;
import net.sf.retrotranslator.transformer.MemberBackport;
import net.sf.retrotranslator.transformer.PackageBackport;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Backport {
    Backport() {
    }

    public static List<Backport> getBackports(String s) {
        int colonIndex = s.indexOf(58);
        if (colonIndex < 0) {
            return Collections.singletonList(new PackageBackport("", Backport.toPrefixName(s.trim())));
        }
        String leftToken = s.substring(0, colonIndex).trim();
        String rightToken = s.substring(colonIndex + 1).trim();
        int leftIndex = leftToken.lastIndexOf(46);
        int rightIndex = rightToken.lastIndexOf(46);
        ArrayList<Backport> result = new ArrayList<Backport>();
        if (leftIndex >= 0 && rightIndex >= 0) {
            result.add(new MemberBackport(Backport.toInternalName(leftToken.substring(0, leftIndex)), leftToken.substring(leftIndex + 1), Backport.toInternalName(rightToken.substring(0, rightIndex)), rightToken.substring(rightIndex + 1)));
        }
        result.add(new ClassBackport(Backport.toInternalName(leftToken), Backport.toInternalName(rightToken)));
        result.add(new PackageBackport(Backport.toPrefixName(leftToken), Backport.toPrefixName(rightToken)));
        return result;
    }

    private static String toInternalName(String name) {
        return name.replace('.', '/');
    }

    private static String toPrefixName(String name) {
        return new StringBuffer().append(Backport.toInternalName(name)).append('/').toString();
    }
}

