/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import net.sf.retrotranslator.transformer.Level;
import net.sf.retrotranslator.transformer.Message;
import net.sf.retrotranslator.transformer.MessageLogger;

public abstract class AbstractLogger
implements MessageLogger {
    private Message lastMessage;

    public void log(Message message) {
        if (message.getFileName() == null) {
            this.log(message.getText(), message.getLevel());
        } else {
            if (!this.isLikePrevious(message)) {
                this.log(message.getFileName(), message.getLevel());
            }
            this.log("    " + message.getText(), message.getLevel());
        }
        this.lastMessage = message;
    }

    protected abstract void log(String var1, Level var2);

    private boolean isLikePrevious(Message message) {
        return AbstractLogger.equal(message.getLevel(), this.lastMessage.getLevel()) && AbstractLogger.equal(message.getFileName(), this.lastMessage.getFileName()) && AbstractLogger.equal(message.getFileLocation(), this.lastMessage.getFileLocation());
    }

    private static boolean equal(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }
}

