/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.Manifest;
import net.sf.retrotranslator.runtime.impl.RuntimeTools;
import net.sf.retrotranslator.transformer.ClassTransformer;
import net.sf.retrotranslator.transformer.JarClassLoader;

public class TransformingJarClassLoader
extends JarClassLoader {
    private final ClassTransformer transformer;

    public TransformingJarClassLoader(File file, ClassLoader parent, ClassTransformer transformer) throws IOException {
        super(file, parent);
        this.transformer = transformer;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        URL resource = this.findResource(name.replace('.', '/').concat(".class"));
        if (resource == null) {
            throw new ClassNotFoundException(name);
        }
        try {
            URLConnection connection = resource.openConnection();
            this.initPackage(name, connection, resource);
            byte[] content = RuntimeTools.readAndClose(connection.getInputStream());
            content = this.transformer.transform(content, 0, content.length);
            return this.defineClass(name, content, 0, content.length);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
    }

    private void initPackage(String className, URLConnection connection, URL resource) throws IOException {
        String packageName = TransformingJarClassLoader.getPackageName(className);
        if (packageName == null || this.getPackage(packageName) != null) {
            return;
        }
        Manifest manifest = TransformingJarClassLoader.getManifest(connection);
        try {
            if (manifest != null) {
                this.definePackage(packageName, manifest, resource);
            } else {
                this.definePackage(packageName, null, null, null, null, null, null, null);
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    private static String getPackageName(String className) {
        int dotIndex = className.lastIndexOf(46);
        return dotIndex < 0 ? null : className.substring(0, dotIndex);
    }

    private static Manifest getManifest(URLConnection connection) throws IOException {
        if (connection instanceof JarURLConnection) {
            return ((JarURLConnection)connection).getManifest();
        }
        return null;
    }
}

