/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import java.util.StringTokenizer;
import java.util.regex.Pattern;
import net.sf.retrotranslator.runtime.java.util.regex._Pattern;

class SourceMask {
    private Pattern pattern;

    public SourceMask(String srcmask) {
        if (srcmask == null) {
            this.pattern = null;
            return;
        }
        StringBuffer builder = new StringBuffer();
        String[] arr$ = srcmask.split(";");
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String s = arr$[i$];
            if (builder.length() > 0) {
                builder.append('|');
            }
            builder.append("((./)?");
            StringTokenizer tokenizer = new StringTokenizer(s, "*?", true);
            while (tokenizer.hasMoreTokens()) {
                builder.append(SourceMask.wildcardToRegex(tokenizer.nextToken()));
            }
            builder.append(")");
        }
        this.pattern = Pattern.compile(builder.toString());
    }

    private static String wildcardToRegex(String s) {
        if (s.equals("*")) {
            return ".*";
        }
        if (s.equals("?")) {
            return ".";
        }
        return _Pattern.quote(s);
    }

    public boolean matches(String name) {
        return this.pattern != null ? this.pattern.matcher(name).matches() : name.endsWith(".class");
    }
}

