/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.sf.retrotranslator.transformer.AbstractLogger;
import net.sf.retrotranslator.transformer.Level;
import net.sf.retrotranslator.transformer.Retrotranslator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class RetrotranslatorTask
extends Task {
    private File srcdir;
    private File srcjar;
    private File destdir;
    private File destjar;
    private List<FileSet> fileSets = new ArrayList<FileSet>();
    private List<FileSet> jarFileSets = new ArrayList<FileSet>();
    private List<DirSet> dirSets = new ArrayList<DirSet>();
    private boolean verbose;
    private boolean stripsign;
    private boolean stripannot;
    private boolean retainapi;
    private boolean retainflags;
    private boolean lazy;
    private boolean advanced;
    private boolean verify;
    private boolean uptodatecheck;
    private boolean smart;
    private boolean syncvolatile;
    private boolean syncfinal;
    private boolean keepclasslit;
    private boolean failonwarning = true;
    private String srcmask;
    private String embed;
    private String support;
    private String backport;
    private String target;
    private String reflection;
    private Path classpath;

    public void setSrcdir(File srcdir) {
        this.srcdir = srcdir;
    }

    public void setSrcjar(File srcjar) {
        this.srcjar = srcjar;
    }

    public void setDestdir(File destdir) {
        this.destdir = destdir;
    }

    public void setDestjar(File destjar) {
        this.destjar = destjar;
    }

    public void addConfiguredFileset(FileSet fileSet) {
        this.fileSets.add(fileSet);
    }

    public void addConfiguredJarfileset(FileSet fileSet) {
        this.jarFileSets.add(fileSet);
    }

    public void addConfiguredDirset(DirSet dirSet) {
        this.dirSets.add(dirSet);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setStripsign(boolean stripsign) {
        this.stripsign = stripsign;
    }

    public void setStripannot(boolean stripannot) {
        this.stripannot = stripannot;
    }

    public void setRetainapi(boolean retainapi) {
        this.retainapi = retainapi;
    }

    public void setRetainflags(boolean retainflags) {
        this.retainflags = retainflags;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public void setAdvanced(boolean advanced) {
        this.advanced = advanced;
    }

    public void setVerify(boolean verify) {
        this.verify = verify;
    }

    public void setUptodatecheck(boolean uptodatecheck) {
        this.uptodatecheck = uptodatecheck;
    }

    public void setSmart(boolean smart) {
        this.smart = smart;
    }

    public void setSyncvolatile(boolean syncvolatile) {
        this.syncvolatile = syncvolatile;
    }

    public void setSyncfinal(boolean syncfinal) {
        this.syncfinal = syncfinal;
    }

    public void setKeepclasslit(boolean keepclasslit) {
        this.keepclasslit = keepclasslit;
    }

    public void setFailonwarning(boolean failonwarning) {
        this.failonwarning = failonwarning;
    }

    public void setSrcmask(String srcmask) {
        this.srcmask = srcmask;
    }

    public void setEmbed(String embed) {
        this.embed = embed;
    }

    public void setSupport(String support) {
        this.support = support;
    }

    public void setBackport(String backport) {
        this.backport = backport;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setReflection(String reflection) {
        this.reflection = reflection;
    }

    public void setClasspathref(Reference classpathref) {
        this.createClasspath().setRefid(classpathref);
    }

    public void setClasspath(Path classpath) {
        this.getClasspath().append(classpath);
    }

    public Path createClasspath() {
        return this.getClasspath().createPath();
    }

    private Path getClasspath() {
        return this.classpath != null ? this.classpath : (this.classpath = new Path(this.getProject()));
    }

    public void execute() throws BuildException {
        try {
            int i$;
            int len$;
            String[] arr$;
            File basedir;
            DirectoryScanner scanner;
            Retrotranslator retrotranslator = new Retrotranslator();
            if (this.srcdir != null) {
                retrotranslator.addSrcdir(this.srcdir);
            }
            if (this.srcjar != null) {
                retrotranslator.addSrcjar(this.srcjar);
            }
            if (this.destdir != null) {
                retrotranslator.setDestdir(this.destdir);
            }
            if (this.destjar != null) {
                retrotranslator.setDestjar(this.destjar);
            }
            Iterator<FileSet> i$2 = this.fileSets.iterator();
            while (i$2.hasNext()) {
                FileSet fileSet = i$2.next();
                scanner = fileSet.getDirectoryScanner(this.getProject());
                retrotranslator.addSourceFiles(scanner.getBasedir(), Arrays.asList(scanner.getIncludedFiles()));
            }
            i$2 = this.jarFileSets.iterator();
            while (i$2.hasNext()) {
                FileSet jarFileSet = i$2.next();
                scanner = jarFileSet.getDirectoryScanner(this.getProject());
                basedir = scanner.getBasedir();
                arr$ = scanner.getIncludedFiles();
                len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    String jarFile = arr$[i$];
                    retrotranslator.addSrcjar(new File(basedir, jarFile));
                }
            }
            i$2 = this.dirSets.iterator();
            while (i$2.hasNext()) {
                DirSet dirSet = (DirSet)i$2.next();
                scanner = dirSet.getDirectoryScanner(this.getProject());
                basedir = scanner.getBasedir();
                arr$ = scanner.getIncludedDirectories();
                len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    String subdirectory = arr$[i$];
                    retrotranslator.addSrcdir(new File(basedir, subdirectory));
                }
            }
            retrotranslator.setVerbose(this.verbose);
            retrotranslator.setStripsign(this.stripsign);
            retrotranslator.setStripannot(this.stripannot);
            retrotranslator.setRetainapi(this.retainapi);
            retrotranslator.setRetainflags(this.retainflags);
            retrotranslator.setLazy(this.lazy);
            retrotranslator.setAdvanced(this.advanced);
            retrotranslator.setVerify(this.verify);
            retrotranslator.setUptodatecheck(this.uptodatecheck);
            retrotranslator.setSmart(this.smart);
            retrotranslator.setSyncvolatile(this.syncvolatile);
            retrotranslator.setSyncfinal(this.syncfinal);
            retrotranslator.setKeepclasslit(this.keepclasslit);
            retrotranslator.setSrcmask(this.srcmask);
            retrotranslator.setEmbed(this.embed);
            retrotranslator.setSupport(this.support);
            retrotranslator.setBackport(this.backport);
            if (this.target != null) {
                retrotranslator.setTarget(this.target);
            }
            if (this.reflection != null) {
                retrotranslator.setReflection(this.reflection);
            }
            String[] arr$2 = this.getClasspath().list();
            int len$2 = arr$2.length;
            for (int i$3 = 0; i$3 < len$2; ++i$3) {
                String fileName = arr$2[i$3];
                retrotranslator.addClasspathElement(this.getProject().resolveFile(fileName));
            }
            retrotranslator.setLogger(new AbstractLogger(){

                protected void log(String text, Level level) {
                    RetrotranslatorTask.this.log(text, level.isCritical() ? 1 : 2);
                }
            });
            boolean success = retrotranslator.run();
            if (!success && this.failonwarning) {
                throw new BuildException("Translation failed.", this.getLocation());
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }
}

