/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import java.util.LinkedHashSet;
import java.util.Set;
import net.sf.retrotranslator.runtime.asm.ClassReader;
import net.sf.retrotranslator.runtime.asm.MethodVisitor;
import net.sf.retrotranslator.runtime.asm.Type;
import net.sf.retrotranslator.runtime.impl.EmptyVisitor;
import net.sf.retrotranslator.runtime.impl.RuntimeTools;
import net.sf.retrotranslator.transformer.ClassVersion;
import net.sf.retrotranslator.transformer.GenericClassVisitor;
import net.sf.retrotranslator.transformer.Level;
import net.sf.retrotranslator.transformer.MemberFinder;
import net.sf.retrotranslator.transformer.SystemLogger;
import net.sf.retrotranslator.transformer.TargetEnvironment;

class ReferenceVerifyingVisitor
extends GenericClassVisitor {
    private final ClassVersion target;
    private final TargetEnvironment environment;
    private final SystemLogger logger;
    private Set<String> warnings;

    public ReferenceVerifyingVisitor(ClassVersion target, TargetEnvironment environment, SystemLogger logger) {
        super(new EmptyVisitor());
        this.target = target;
        this.environment = environment;
        this.logger = logger;
    }

    public int verify(byte[] bytes) {
        this.warnings = new LinkedHashSet<String>();
        new ClassReader(bytes).accept(this, true);
        return this.warnings.size();
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.checkVersion(version, name);
        super.visit(version, access, name, signature, superName, interfaces);
    }

    private void checkVersion(int version, String name) {
        if (this.target.isBefore(version)) {
            this.println("Incompatible class: " + RuntimeTools.getDisplayClassName(name));
        }
    }

    protected String typeName(String s) {
        if (s == null) {
            return null;
        }
        try {
            this.environment.getClassReader(s);
        }
        catch (ClassNotFoundException e) {
            this.printClassNotFound(e);
        }
        return s;
    }

    private void printClassNotFound(ClassNotFoundException e) {
        this.println("Class not found: " + RuntimeTools.getDisplayClassName(e.getMessage()));
    }

    protected void visitFieldInstruction(MethodVisitor visitor, int opcode, String owner, String name, String desc) {
        super.visitFieldInstruction(visitor, opcode, owner, name, desc);
        boolean stat = opcode == 178 || opcode == 179;
        try {
            int found = this.findMember(false, stat, name, desc, owner);
            if (found == 0) {
                this.println(ReferenceVerifyingVisitor.getFieldInfo(owner, stat, name, desc, "not found"));
            } else if (found > 1) {
                this.println(ReferenceVerifyingVisitor.getFieldInfo(owner, stat, name, desc, "duplicated"));
            }
        }
        catch (ClassNotFoundException e) {
            this.cannotVerify(ReferenceVerifyingVisitor.getFieldInfo(owner, stat, name, desc, "not verified"), e);
        }
    }

    protected void visitMethodInstruction(MethodVisitor visitor, int opcode, String owner, String name, String desc) {
        super.visitMethodInstruction(visitor, opcode, owner, name, desc);
        if (owner.startsWith("[")) {
            return;
        }
        boolean stat = opcode == 184;
        try {
            int found = this.findMember(true, stat, name, desc, owner);
            if (found == 0) {
                this.println(ReferenceVerifyingVisitor.getMethodInfo(owner, stat, name, desc, "not found"));
            } else if (found > 1) {
                this.println(ReferenceVerifyingVisitor.getMethodInfo(owner, stat, name, desc, "duplicated"));
            }
        }
        catch (ClassNotFoundException e) {
            this.cannotVerify(ReferenceVerifyingVisitor.getMethodInfo(owner, stat, name, desc, "not verified"), e);
        }
    }

    private int findMember(boolean method, boolean stat, String name, String desc, String owner) throws ClassNotFoundException {
        return new MemberFinder(this.environment, method, stat, name, desc){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                ReferenceVerifyingVisitor.this.checkVersion(version, name);
                super.visit(version, access, name, signature, superName, interfaces);
            }
        }.findIn(owner, null);
    }

    private void cannotVerify(String text, ClassNotFoundException e) {
        this.printClassNotFound(e);
        this.println(text);
    }

    private void println(String text) {
        if (!this.warnings.contains(text)) {
            this.warnings.add(text);
            this.logger.logForFile(Level.WARNING, text);
        }
    }

    private static String getFieldInfo(String owner, boolean stat, String name, String desc, String message) {
        StringBuffer buffer = new StringBuffer("Field ").append(message).append(": ");
        if (stat) {
            buffer.append("static ");
        }
        buffer.append(Type.getType(desc).getClassName()).append(' ');
        buffer.append(RuntimeTools.getDisplayClassName(owner)).append('.').append(name);
        return buffer.toString();
    }

    private static String getMethodInfo(String owner, boolean stat, String name, String desc, String message) {
        StringBuffer buffer = new StringBuffer();
        if (name.equals("<init>")) {
            buffer.append("Constructor ").append(message).append(": ");
            buffer.append(RuntimeTools.getDisplayClassName(owner));
        } else {
            buffer.append("Method ").append(message).append(": ");
            if (stat) {
                buffer.append("static ");
            }
            buffer.append(Type.getReturnType(desc).getClassName());
            buffer.append(' ').append(RuntimeTools.getDisplayClassName(owner)).append('.').append(name);
        }
        buffer.append('(');
        boolean first = true;
        Type[] arr$ = Type.getArgumentTypes(desc);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Type type = arr$[i$];
            buffer.append(first ? "" : ",").append(type.getClassName());
            first = false;
        }
        return buffer.append(')').toString();
    }
}

