/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.retrotranslator.runtime.asm.ClassAdapter;
import net.sf.retrotranslator.runtime.asm.ClassVisitor;
import net.sf.retrotranslator.runtime.asm.MethodVisitor;
import net.sf.retrotranslator.runtime.java.lang._Integer;
import net.sf.retrotranslator.transformer.AbstractMethodVisitor;

class InnerClassVisitor
extends ClassAdapter {
    private String thisName;
    private String superName;

    public InnerClassVisitor(ClassVisitor visitor) {
        super(visitor);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.thisName = name;
        this.superName = superName;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
        if (methodVisitor != null && this.superName != null && name.equals("<init>")) {
            return new InnerClassMethodVisitor(methodVisitor);
        }
        return methodVisitor;
    }

    private class InnerClassMethodVisitor
    extends AbstractMethodVisitor {
        private boolean initialized;
        private int thisCount;
        private int superCount;
        private boolean thisLoaded;
        private Integer localVariable;
        private List<FieldAssignment> assignments;

        public InnerClassMethodVisitor(MethodVisitor visitor) {
            super(visitor);
        }

        protected void flush() {
            if (this.thisLoaded) {
                this.mv.visitVarInsn(25, 0);
                this.thisLoaded = false;
                if (this.localVariable != null) {
                    this.mv.visitVarInsn(25, this.localVariable);
                    this.localVariable = null;
                }
            }
            if (this.initialized && this.assignments != null) {
                Iterator<FieldAssignment> i$ = this.assignments.iterator();
                while (i$.hasNext()) {
                    FieldAssignment assignment = i$.next();
                    this.mv.visitVarInsn(25, 0);
                    this.mv.visitVarInsn(25, assignment.localVariable);
                    this.mv.visitFieldInsn(181, InnerClassVisitor.this.thisName, assignment.fieldName, assignment.fieldType);
                }
                this.assignments = null;
            }
        }

        public void visitVarInsn(int opcode, int var) {
            if (!this.initialized && opcode == 25 && this.localVariable == null) {
                if (this.thisLoaded) {
                    this.localVariable = _Integer.valueOf(var);
                    return;
                }
                if (var == 0) {
                    this.thisLoaded = true;
                    return;
                }
            }
            super.visitVarInsn(opcode, var);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (!this.initialized && opcode == 181 && this.localVariable != null && owner.equals(InnerClassVisitor.this.thisName)) {
                if (this.assignments == null) {
                    this.assignments = new ArrayList<FieldAssignment>();
                }
                this.assignments.add(new FieldAssignment(this.localVariable, name, desc));
                this.thisLoaded = false;
                this.localVariable = null;
                return;
            }
            super.visitFieldInsn(opcode, owner, name, desc);
        }

        public void visitTypeInsn(int opcode, String desc) {
            super.visitTypeInsn(opcode, desc);
            if (this.initialized || opcode != 187) {
                return;
            }
            if (desc.equals(InnerClassVisitor.this.thisName)) {
                ++this.thisCount;
            }
            if (desc.equals(InnerClassVisitor.this.superName)) {
                ++this.superCount;
            }
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            super.visitMethodInsn(opcode, owner, name, desc);
            if (this.initialized || opcode != 183 || !name.equals("<init>")) {
                return;
            }
            if (owner.equals(InnerClassVisitor.this.thisName)) {
                if (this.thisCount > 0) {
                    --this.thisCount;
                } else {
                    this.initialized = true;
                }
            }
            if (owner.equals(InnerClassVisitor.this.superName)) {
                if (this.superCount > 0) {
                    --this.superCount;
                } else {
                    this.initialized = true;
                }
            }
        }

        public void visitEnd() {
            super.visitEnd();
            if (!this.initialized) {
                throw new IllegalStateException("Constructor not called.");
            }
        }
    }

    private static class FieldAssignment {
        public final int localVariable;
        public final String fieldName;
        public final String fieldType;

        public FieldAssignment(int localVariable, String fieldName, String fieldType) {
            this.localVariable = localVariable;
            this.fieldName = fieldName;
            this.fieldType = fieldType;
        }
    }
}

