/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.retrotranslator.runtime.asm.Type;
import net.sf.retrotranslator.transformer.ConstructorReplacement;
import net.sf.retrotranslator.transformer.MemberKey;
import net.sf.retrotranslator.transformer.MemberReplacement;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassReplacement {
    private String uniqueTypeName;
    private String referenceTypeName;
    private MemberReplacement checkCastReplacement;
    private MemberReplacement instanceOfReplacement;
    private final Map<MemberKey, MemberReplacement> fieldReplacements = ClassReplacement.createMap();
    private final Map<String, ConstructorReplacement> constructorReplacements = ClassReplacement.createMap();
    private final Map<String, MemberReplacement> converterReplacements = ClassReplacement.createMap();
    private final Map<MemberKey, MemberReplacement> methodReplacements = ClassReplacement.createMap();
    private final Map<String, MemberReplacement> instantiationReplacements = ClassReplacement.createMap();

    public String getUniqueTypeName() {
        return this.uniqueTypeName;
    }

    public void setUniqueTypeName(String uniqueTypeName) {
        this.uniqueTypeName = uniqueTypeName;
    }

    public String getReferenceTypeName() {
        return this.referenceTypeName;
    }

    public void setReferenceTypeName(String referenceTypeName) {
        this.referenceTypeName = referenceTypeName;
    }

    public MemberReplacement getCheckCastReplacement() {
        return this.checkCastReplacement;
    }

    public void setCheckCastReplacement(MemberReplacement checkCastReplacement) {
        this.checkCastReplacement = checkCastReplacement;
    }

    public MemberReplacement getInstanceOfReplacement() {
        return this.instanceOfReplacement;
    }

    public void setInstanceOfReplacement(MemberReplacement instanceOfReplacement) {
        this.instanceOfReplacement = instanceOfReplacement;
    }

    public Map<MemberKey, MemberReplacement> getFieldReplacements() {
        return this.fieldReplacements;
    }

    public Map<String, ConstructorReplacement> getConstructorReplacements() {
        return this.constructorReplacements;
    }

    public Map<String, MemberReplacement> getConverterReplacements() {
        return this.converterReplacements;
    }

    public Map<MemberKey, MemberReplacement> getMethodReplacements() {
        return this.methodReplacements;
    }

    public Map<String, MemberReplacement> getInstantiationReplacements() {
        return this.instantiationReplacements;
    }

    public boolean isEmpty(String className) {
        return this.uniqueTypeName.equals(className) && this.referenceTypeName.equals(className) && this.checkCastReplacement == null && this.instanceOfReplacement == null && this.fieldReplacements.isEmpty() && this.constructorReplacements.isEmpty() && this.converterReplacements.isEmpty() && this.methodReplacements.isEmpty() && this.instantiationReplacements.isEmpty();
    }

    private static <K, V> Map<K, V> createMap() {
        return Collections.synchronizedMap(new LinkedHashMap());
    }

    static String getConstructorDesc(MemberReplacement converter) {
        return Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getReturnType(converter.getDesc())});
    }
}

