/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.runtime13.v14.java.lang;

import java.io.Serializable;

public final class StackTraceElement_
implements Serializable {
    private static final String NATIVE_METHOD = "Native Method";
    private static final String UNKNOWN_SOURCE = "Unknown Source";
    private String declaringClass;
    private String methodName;
    private String fileName;
    private int lineNumber;

    public StackTraceElement_(String declaringClass, String methodName, String fileName, int lineNumber) {
        if (declaringClass == null || methodName == null) {
            throw new NullPointerException();
        }
        this.declaringClass = declaringClass;
        this.methodName = methodName;
        this.fileName = fileName;
        this.lineNumber = lineNumber;
    }

    public String getClassName() {
        return this.declaringClass;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean isNativeMethod() {
        return this.lineNumber == -2;
    }

    public String toString() {
        StringBuffer builder = new StringBuffer(this.declaringClass).append('.').append(this.methodName).append('(');
        if (this.fileName != null) {
            builder.append(this.fileName);
            if (this.lineNumber >= 0) {
                builder.append(':').append(this.lineNumber);
            }
        } else {
            builder.append(this.isNativeMethod() ? NATIVE_METHOD : UNKNOWN_SOURCE);
        }
        return builder.append(')').toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StackTraceElement_)) {
            return false;
        }
        StackTraceElement_ element = (StackTraceElement_)obj;
        return StackTraceElement_.equal(this.declaringClass, element.declaringClass) && StackTraceElement_.equal(this.methodName, element.methodName) && StackTraceElement_.equal(this.fileName, element.fileName) && this.lineNumber == element.lineNumber;
    }

    public int hashCode() {
        return ((StackTraceElement_.hash(this.declaringClass) * 31 + StackTraceElement_.hash(this.methodName)) * 31 + StackTraceElement_.hash(this.fileName)) * 31 + this.lineNumber;
    }

    private static boolean equal(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    private static int hash(Object o) {
        return o != null ? o.hashCode() : 0;
    }

    static StackTraceElement_ valueOf(String s) {
        int openIndex = s.lastIndexOf(40);
        if (openIndex < 0 || !s.endsWith(")")) {
            return null;
        }
        int dotIndex = s.lastIndexOf(46, openIndex);
        if (dotIndex < 0) {
            return null;
        }
        String declaringClass = s.substring(0, dotIndex);
        String methodName = s.substring(dotIndex + 1, openIndex);
        String position = s.substring(openIndex + 1, s.length() - 1);
        String fileName = null;
        int lineNumber = -1;
        if (position.equals(NATIVE_METHOD)) {
            lineNumber = -2;
        } else if (!position.equals(UNKNOWN_SOURCE)) {
            int colonIndex = position.lastIndexOf(58);
            if (colonIndex < 0) {
                fileName = position;
            } else {
                try {
                    lineNumber = Integer.parseInt(position.substring(colonIndex + 1));
                    fileName = position.substring(0, colonIndex);
                }
                catch (NumberFormatException e) {
                    fileName = position;
                }
            }
        }
        int index = methodName.indexOf(40);
        if (index >= 0) {
            methodName = methodName.substring(0, index);
        }
        return new StackTraceElement_(declaringClass, methodName, fileName, lineNumber);
    }
}

