/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;

public class CountDownLatch {
    private int count_;

    public CountDownLatch(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count < 0");
        }
        this.count_ = count;
    }

    public void await() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        CountDownLatch countDownLatch = this;
        synchronized (countDownLatch) {
            while (this.count_ > 0) {
                this.wait();
            }
        }
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        long nanos = unit.toNanos(timeout);
        CountDownLatch countDownLatch = this;
        synchronized (countDownLatch) {
            if (this.count_ <= 0) {
                boolean bl = true;
                return bl;
            }
            if (nanos <= 0L) {
                boolean bl = false;
                return bl;
            }
            long deadline = Utils.nanoTime() + nanos;
            do {
                TimeUnit.NANOSECONDS.timedWait(this, nanos);
                if (this.count_ > 0) continue;
                boolean bl = true;
                return bl;
            } while ((nanos = deadline - Utils.nanoTime()) > 0L);
            boolean bl = false;
            return bl;
        }
    }

    public synchronized void countDown() {
        if (this.count_ == 0) {
            return;
        }
        if (--this.count_ == 0) {
            this.notifyAll();
        }
    }

    public long getCount() {
        return this.count_;
    }

    public String toString() {
        return super.toString() + "[Count = " + this.getCount() + "]";
    }
}

