/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.runtime13.v15.java.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import net.sf.retrotranslator.runtime13.v15.java.lang.Enum_;
import net.sf.retrotranslator.runtime13.v15.java.lang._Class;

/*
 * This class specifies class file version 47.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumSet_<E extends Enum_<E>>
extends HashSet<E> {
    private static final long serialVersionUID = 7684628957901243852L;
    private Class<E> elementType;
    private static final Comparator<Enum_> ENUM_COMPARATOR = new Comparator<Enum_>(){

        @Override
        public int compare(Enum_ o1, Enum_ o2) {
            return o1.ordinal() - o2.ordinal();
        }

        @Override
        public /* synthetic */ int compare(Object x0, Object x1) {
            return this.compare((Enum_)x0, (Enum_)x1);
        }
    };
    static /* synthetic */ Class class$net$sf$retrotranslator$runtime13$v15$java$lang$Enum_;

    private EnumSet_(Class<E> elementType) {
        Class<E> clazz = class$net$sf$retrotranslator$runtime13$v15$java$lang$Enum_;
        if (clazz == null) {
            clazz = class$net$sf$retrotranslator$runtime13$v15$java$lang$Enum_ = new Enum_[0].getClass().getComponentType();
        }
        if (!clazz.isAssignableFrom(elementType)) {
            throw new ClassCastException();
        }
        this.elementType = elementType;
    }

    public static <E extends Enum_<E>> EnumSet_<E> allOf(Class<E> elementType) {
        EnumSet_<Enum_> result = new EnumSet_<Enum_>(elementType);
        for (Enum_ e : (Enum_[])_Class.getEnumConstants(elementType)) {
            result.add(e);
        }
        return result;
    }

    public static <E extends Enum_<E>> EnumSet_<E> complementOf(EnumSet_<E> enumSet) {
        Class<E> elementType = enumSet.elementType;
        EnumSet_<Enum_> result = new EnumSet_<Enum_>(elementType);
        for (Enum_ e : (Enum_[])_Class.getEnumConstants(elementType)) {
            if (enumSet.contains(e)) continue;
            result.add(e);
        }
        return result;
    }

    public static <E extends Enum_<E>> EnumSet_<E> copyOf(Collection<E> collection) {
        if (collection instanceof EnumSet_) {
            return EnumSet_.copyOf((EnumSet_)collection);
        }
        Iterator<E> iterator = collection.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException();
        }
        EnumSet_<Enum_> result = EnumSet_.of((Enum_)iterator.next());
        while (iterator.hasNext()) {
            result.add((Enum_)iterator.next());
        }
        return result;
    }

    public static <E extends Enum_<E>> EnumSet_<E> copyOf(EnumSet_<E> enumSet) {
        return enumSet.clone();
    }

    public static <E extends Enum_<E>> EnumSet_<E> noneOf(Class<E> elementType) {
        return new EnumSet_<E>(elementType);
    }

    public static <E extends Enum_<E>> EnumSet_<E> of(E e) {
        EnumSet_<E> result = new EnumSet_<E>(e.getDeclaringClass());
        result.add(e);
        return result;
    }

    public static <E extends Enum_<E>> EnumSet_<E> of(E e1, E e2) {
        EnumSet_<E> result = EnumSet_.of(e1);
        result.add(e2);
        return result;
    }

    public static <E extends Enum_<E>> EnumSet_<E> of(E e1, E e2, E e3) {
        EnumSet_<E> result = EnumSet_.of(e1);
        result.add(e2);
        result.add(e3);
        return result;
    }

    public static <E extends Enum_<E>> EnumSet_<E> of(E e1, E e2, E e3, E e4) {
        EnumSet_<E> result = EnumSet_.of(e1);
        result.add(e2);
        result.add(e3);
        result.add(e4);
        return result;
    }

    public static <E extends Enum_<E>> EnumSet_<E> of(E e1, E e2, E e3, E e4, E e5) {
        EnumSet_<E> result = EnumSet_.of(e1);
        result.add(e2);
        result.add(e3);
        result.add(e4);
        result.add(e5);
        return result;
    }

    public static <E extends Enum_<E>> EnumSet_<E> of(E first, E[] rest) {
        EnumSet_<E> result = EnumSet_.of(first);
        for (E e : rest) {
            result.add(e);
        }
        return result;
    }

    public static <E extends Enum_<E>> EnumSet_<E> range(E from, E to) {
        int toIndex;
        int fromIndex = from.ordinal();
        if (fromIndex > (toIndex = to.ordinal())) {
            throw new IllegalArgumentException();
        }
        Class<E> elementType = from.getDeclaringClass();
        Enum_[] enumConstants = (Enum_[])_Class.getEnumConstants(elementType);
        EnumSet_<Enum_> result = new EnumSet_<Enum_>(elementType);
        for (int i = fromIndex; i <= toIndex; ++i) {
            Enum_ enumConstant = enumConstants[i];
            result.add(enumConstant);
        }
        return result;
    }

    @Override
    public boolean add(E o) {
        if (o == null) {
            throw new NullPointerException();
        }
        return super.add(_Class.cast(this.elementType, o));
    }

    @Override
    public Iterator<E> iterator() {
        TreeSet<Enum_> treeSet = new TreeSet<Enum_>(ENUM_COMPARATOR);
        Iterator iterator = super.iterator();
        while (iterator.hasNext()) {
            treeSet.add((Enum_)iterator.next());
        }
        return treeSet.iterator();
    }

    @Override
    public EnumSet_<E> clone() {
        return (EnumSet_)super.clone();
    }

    @Override
    public /* synthetic */ Object clone() {
        return this.clone();
    }

    @Override
    public /* synthetic */ boolean add(Object x0) {
        return this.add((E)((Enum_)x0));
    }
}

