/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import net.sf.retrotranslator.transformer.ClassVersion;
import net.sf.retrotranslator.transformer.FileEntry;
import net.sf.retrotranslator.transformer.TransformerTools;

class OperationMode {
    private final boolean advanced;
    private final boolean smart;
    private final Set<String> features = Collections.synchronizedSet(new HashSet());
    private final ClassVersion target;
    private final boolean fixHyphen;

    public OperationMode(boolean advanced, String support, boolean smart, ClassVersion target) {
        this.advanced = advanced;
        this.target = target;
        this.smart = smart;
        if (support != null) {
            if (advanced) {
                throw new IllegalArgumentException("The -support option is unnecessary when -advanced is specified.");
            }
            StringTokenizer tokenizer = new StringTokenizer(support, ";");
            while (tokenizer.hasMoreTokens()) {
                this.features.add(tokenizer.nextToken());
            }
        }
        this.fixHyphen = this.isSupportedFeature("Retrotranslator.fixHyphen");
    }

    public boolean isSupportedFeature(String feature) {
        return this.advanced || this.features.contains(feature);
    }

    public boolean isSmart() {
        return this.smart;
    }

    public ClassVersion getTarget() {
        return this.target;
    }

    public String fixName(String className) {
        return this.fixHyphen ? className.replace('-', '$') : className;
    }

    public String fixFileName(String fileName, FileEntry entry) {
        return this.fixHyphen && fileName.indexOf(45) >= 0 && TransformerTools.isClassFile(entry.getContent()) ? fileName.replace('-', '$') : fileName;
    }
}

