/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.sf.retrotranslator.transformer.FileContainer;
import net.sf.retrotranslator.transformer.FileEntry;
import net.sf.retrotranslator.transformer.Level;
import net.sf.retrotranslator.transformer.Message;
import net.sf.retrotranslator.transformer.SystemLogger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JarFileContainer
extends FileContainer {
    private static final String META_INF_NAME = "META-INF/";
    private static final Pattern SIGNATURE_ENTRY = Pattern.compile("META-INF/SIG-.+|META-INF/.+\\.(SF|DSA|RSA)");
    private static final Pattern SIGNATURE_ATTRIBUTE = Pattern.compile("Magic|.+-Digest(-.+)?");
    private Map<String, JarFileEntry> entries;
    private boolean modified;

    public JarFileContainer(File location) {
        super(location);
    }

    @Override
    public Collection<? extends FileEntry> getEntries() {
        if (this.entries == null) {
            this.loadEntries();
        }
        return new ArrayList<JarFileEntry>(this.entries.values());
    }

    @Override
    public void removeEntry(String name) {
        if (this.entries != null) {
            this.entries.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadEntries() {
        this.initEntries();
        try {
            long lastModified = this.location.lastModified();
            FileInputStream fileInputStream = new FileInputStream(this.location);
            try {
                ZipEntry entry;
                ZipInputStream stream = new ZipInputStream(fileInputStream);
                while ((entry = stream.getNextEntry()) != null) {
                    if (entry.isDirectory()) continue;
                    byte[] content = JarFileContainer.readFully(stream, (int)entry.getSize());
                    this.entries.put(entry.getName(), new JarFileEntry(entry.getName(), content, lastModified, false));
                }
            }
            finally {
                fileInputStream.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void putEntry(String name, byte[] contents, boolean modified) {
        this.initEntries();
        this.entries.put(name, new JarFileEntry(name, contents, 0L, modified));
        this.modified = true;
    }

    private void initEntries() {
        if (this.entries == null) {
            this.entries = new LinkedHashMap<String, JarFileEntry>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(SystemLogger logger) {
        if (!this.modified) {
            return;
        }
        try {
            FileOutputStream stream = new FileOutputStream(this.location);
            try {
                this.flush(stream, logger);
                this.modified = false;
            }
            finally {
                stream.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean containsUpToDate(String name, long sourceTime) {
        return false;
    }

    @Override
    public long lastModified() {
        return this.location.lastModified();
    }

    private void flush(FileOutputStream fileOutputStream, SystemLogger logger) throws IOException {
        Manifest manifest = this.getManifest();
        boolean signatureRemoved = this.removeSignature(manifest);
        List<JarFileEntry> fileEntries = this.getFileEntries(logger, signatureRemoved);
        Set<String> folderNames = this.getFolderNames(fileEntries);
        JarOutputStream stream = new JarOutputStream(fileOutputStream);
        stream.setLevel(9);
        stream.putNextEntry(new ZipEntry(META_INF_NAME));
        stream.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
        manifest.write(stream);
        for (String name : folderNames) {
            stream.putNextEntry(new ZipEntry(name));
        }
        for (JarFileEntry entry : fileEntries) {
            stream.putNextEntry(new ZipEntry(entry.getName()));
            stream.write(entry.getContent());
        }
        stream.close();
    }

    private Manifest getManifest() throws IOException {
        JarFileEntry entry = this.entries.get("META-INF/MANIFEST.MF");
        Manifest manifest = entry == null ? new Manifest() : new Manifest(new ByteArrayInputStream(entry.getContent()));
        Attributes attributes = manifest.getMainAttributes();
        attributes.putValue("Manifest-Version", "1.0");
        attributes.putValue("Created-By", new StringBuffer().append(System.getProperty("java.vm.version")).append(" (").append(System.getProperty("java.vm.vendor")).append(")").toString());
        String title = this.getClass().getPackage().getImplementationTitle();
        String version = this.getClass().getPackage().getImplementationVersion();
        if (title != null && version != null) {
            attributes.putValue("Retrotranslator-Version", new StringBuffer().append(title).append(" ").append(version).toString());
        }
        return manifest;
    }

    private boolean removeSignature(Manifest manifest) {
        boolean result = false;
        for (Attributes attributes : manifest.getEntries().values()) {
            Iterator<Map.Entry<Object, Object>> iterator = attributes.entrySet().iterator();
            while (iterator.hasNext()) {
                if (!SIGNATURE_ATTRIBUTE.matcher(iterator.next().getKey().toString()).matches()) continue;
                iterator.remove();
                result = true;
            }
        }
        return result;
    }

    private List<JarFileEntry> getFileEntries(SystemLogger logger, boolean signatureRemoved) {
        ArrayList<JarFileEntry> result = new ArrayList<JarFileEntry>(this.entries.values());
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            JarFileEntry entry = (JarFileEntry)iterator.next();
            if (entry.getName().equals("META-INF/MANIFEST.MF")) {
                iterator.remove();
            }
            if (!SIGNATURE_ENTRY.matcher(entry.getName()).matches()) continue;
            iterator.remove();
            signatureRemoved = true;
        }
        if (signatureRemoved) {
            logger.log(new Message(Level.INFO, new StringBuffer().append("Removing digital signature from ").append(this.location).toString(), this.location, null));
        }
        return result;
    }

    private Set<String> getFolderNames(List<JarFileEntry> entries) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (JarFileEntry entry : entries) {
            String name = entry.getName();
            int index = -1;
            while ((index = name.indexOf(47, index + 1)) >= 0) {
                result.add(name.substring(0, index + 1));
            }
        }
        result.remove(META_INF_NAME);
        return result;
    }

    private static class JarFileEntry
    extends FileEntry {
        private byte[] content;
        private long lastModified;

        public JarFileEntry(String name, byte[] content, long lastModified, boolean modified) {
            super(name, modified);
            this.lastModified = lastModified;
            this.content = content;
        }

        public byte[] getContent() {
            return this.content;
        }

        public long lastModified() {
            return this.lastModified;
        }
    }
}

