/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import java.util.HashSet;
import java.util.Set;
import net.sf.retrotranslator.runtime.asm.ClassAdapter;
import net.sf.retrotranslator.runtime.asm.ClassVisitor;
import net.sf.retrotranslator.runtime.asm.MethodVisitor;
import net.sf.retrotranslator.transformer.Level;
import net.sf.retrotranslator.transformer.MethodCounter;
import net.sf.retrotranslator.transformer.SystemLogger;

class DuplicateMethodsVisitor
extends ClassAdapter {
    private final SystemLogger logger;
    private final MethodCounter counter;
    private final Set<String> visitedMethods = new HashSet<String>();

    public DuplicateMethodsVisitor(ClassVisitor visitor, SystemLogger logger, MethodCounter counter) {
        super(visitor);
        this.logger = logger;
        this.counter = counter;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        String key = name + desc;
        if (this.visitedMethods.contains(key)) {
            this.log(access, name);
            return null;
        }
        if (this.counter.isRepetitive(name, desc) && DuplicateMethodsVisitor.isBridge(access)) {
            this.counter.decrement(name, desc);
            this.log(access, name);
            return null;
        }
        this.visitedMethods.add(key);
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    private void log(int access, String name) {
        if (DuplicateMethodsVisitor.isBridge(access)) {
            this.logger.logForFile(Level.VERBOSE, "Bridge method removed: " + name);
        } else {
            this.logger.logForFile(Level.WARNING, "Repetitive method removed: " + name);
        }
    }

    private static boolean isBridge(int access) {
        return (access & 0x40) != 0;
    }
}

