#!/bin/sh

THISDIR=/media/mmcblk0p1/Programs/_keyboardhack
INSTALLERDIR=/media/mmcblk0p1/Programs/Install
ZENITY=/media/mmcblk0p1/Programs/_base/bin/zenity
MTAG=/media/mmcblk0p1/Programs/_mackxpatch/bin/mtag

cd $THISDIR

backup_firmware () {
    if [ ! -e $THISDIR/liberkeyb_original ]
    then
        /bin/cp -f /usr/lib/liberkeyb.so.0.0.1 $THISDIR/liberkeyb_original
    fi

}

install_patched_files () {
    # copy new files
    # This library contains all real changes of the hack
    /bin/cp -f $THISDIR/lib/liberkeyb.so.0.0.1 /usr/lib/
    # This layout is usedin case the one in $THISDIR/layouts/keymap.xml can not be
    # read for some reason
    /bin/cp -f $THISDIR/layouts/default_keymap.xml /usr/share/er-im-erkeyb/
    /bin/cp -f $THISDIR/layouts/keymap.xml /usr/share/er-im-erkeyb/
	/bin/cp -f $THISDIR/layouts/*.png /usr/share/er-im-erkeyb/
}

restore_original_files () {
    # Restore the original program(s)
    if [ -e $THISDIR/liberkeyb_original ]
    then
        /bin/cp $THISDIR/liberkeyb_original /usr/lib/liberkeyb.so.0.0.1
        /bin/rm -f $THISDIR/liberkeyb_original
    fi
}

# TODO: Check if required components (zenity/mtag) are installed

if [ -f $THISDIR/liberkeyb_original ]; then
    $ZENITY --question --title "KeyBoardHack" --text "<b>De-install</b>\n\nDo you want to restore original IREX programs?"
    if [ $? -eq 0 ]; then
        echo "Restoring original files"
        restore_original_files

        $ZENITY --info --title "KeyBoardHack" --text "<b>Patch Removed</b>\n\nPress ok to reboot"
        /sbin/reboot
        sleep 31
    fi
fi

$ZENITY --question --title "KeyBoardHack" --text "<b>Upgrade</b>\n\nDo you want to install KeyBoardHack?"
if [ $? -eq 0 ]; then
    # We will only come here if de-install was not choosen!!

    # Ask if views need to be installed
    #$ZENITY --question --title "KeyBoardHack" --text "<b>Document Views</b>\n\nDo you want to install the schemas for the new Views?"
    #if [ $? -eq 0 ]; then
    #    echo "Installing schemas for new views"
    #    install_schemas
    #else
    #    echo "Not installing views"
    #fi

    echo "Backingup original firmware files"
    backup_firmware

    echo "Installing patch"
    install_patched_files

    # For the new version to be used, a reset is needed
    # In fact only a restart of the /usr/bin/erkeybd is needed, when experimenting that can be done
    # but for 'final' installation, this seems a better approach
    $ZENITY --info --title "KeyBoardHack" --text "<b>Patch Applied</b>\n\nPress ok to reboot"
    /sbin/reboot
    sleep 31
fi
