/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.kindle.settings.view.settings;

import com.amazon.agui.swing.DefaultDetailElementModel;
import com.amazon.agui.swing.DetailElementModel;
import com.amazon.ebook.util.log.Log;
import com.amazon.kindle.apps.util.CommunicationUtils;
import com.amazon.kindle.apps.util.LogUtils;
import com.amazon.kindle.apps.util.NetworkUtils;
import com.amazon.kindle.booklet.Booklet;
import com.amazon.kindle.booklet.BookletContext;
import com.amazon.kindle.control.DCBooklet;
import com.amazon.kindle.control.widget.DCPagedLandingPanel;
import com.amazon.kindle.net.Wireless;
import com.amazon.kindle.net.WirelessEvent;
import com.amazon.kindle.net.WirelessListener;
import com.amazon.kindle.restricted.net.wifi.WiFi;
import com.amazon.kindle.restricted.net.wifi.WiFiNetwork;
import com.amazon.kindle.settings.SettingsBooklet;
import com.amazon.kindle.settings.property.PageRefreshAction;
import com.amazon.kindle.settings.util.PasscodeUtils;
import com.amazon.kindle.settings.view.settings.DefaultSettingsDisplayController;
import com.amazon.kindle.settings.view.settings.SettingsDisplayController;
import com.amazon.kindle.settings.view.settings.SettingsElementView;
import com.amazon.kindle.webservices.registration.AmazonRegistrationService;
import com.amazon.kindle.webservices.registration.RegistrationEvent;
import com.amazon.kindle.webservices.registration.RegistrationListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.SwingUtilities;

public class SettingsDisplayController
extends DefaultSettingsDisplayController
implements RegistrationListener,
WirelessListener {
    private static final Log u = Log.getInstance((String)"SettingsDisplayController");
    private static final String y = "WIFI_SCAN_CLIENT_ID";
    public static final String O = "SETTINGS";
    private static final int x = 100000;
    private static final int f = 0;
    private DetailElementModel M;
    private DetailElementModel J;
    private DetailElementModel G;
    private DetailElementModel a;
    private DetailElementModel i;
    private DetailElementModel E;
    private DetailElementModel C;
    private DetailElementModel d;
    private SettingsElementView j;
    private SettingsElementView g;
    private SettingsElementView e;
    private SettingsElementView I;
    private SettingsElementView F;
    private SettingsElementView L;
    private SettingsElementView c;
    private SettingsElementView l;
    private List k;
    private List m;
    private boolean h;
    private UpdateWifiCountHandler A;
    private ShowWiFiNetworksRunnable H;
    static /* synthetic */ Class D;

    public static synchronized SettingsDisplayController getInstance(SettingsBooklet a) {
        Object a2 = a.getDisplayController(O);
        if (a2 == null) {
            a2 = new SettingsDisplayController(a);
            a.addDisplayController(O, a2, true);
        }
        return (SettingsDisplayController)((Object)a2);
    }

    private SettingsDisplayController(SettingsBooklet a) {
        super(a);
        SettingsDisplayController a2;
        a2.H = new ShowWiFiNetworksRunnable(a2);
        a2.A = new UpdateWifiCountHandler(a2, null);
        a2.initWidgets();
    }

    public String getViewKey() {
        return O;
    }

    public void willLoad() {
        SettingsDisplayController a;
        super.willLoad();
        a.setupRegistration(true);
        a.setupDevicePasscode(true);
        a.setupWifiNetworks(true);
        a.setupPageRefresh(true);
    }

    public void load() {
        SettingsDisplayController a;
        if (a.booklet == null) {
            LogUtils.logBookletIsNull();
            return;
        }
        BookletContext a2 = a.booklet.getBookletContext();
        if (a2 == null) {
            LogUtils.logBookletContextIsNull();
            return;
        }
        super.load();
        ((AmazonRegistrationService)a2.getService(AmazonRegistrationService.class)).addRegistrationListener((RegistrationListener)a);
        Wireless a3 = (Wireless)a2.getService(Wireless.class);
        a3.addWirelessListener((WirelessListener)a);
        a.B = new DCPagedLandingPanel(a.booklet, a.getUpdatedWidgetList());
        a.B.setHeaderBarEnabled(true);
        a.B.setLayoutParams(true, (int)K, (int)b);
        a.B.initGUI();
    }

    public void unload() {
        SettingsDisplayController a;
        if (a.booklet == null) {
            LogUtils.logBookletIsNull();
            return;
        }
        BookletContext a2 = a.booklet.getBookletContext();
        if (a2 == null) {
            LogUtils.logBookletContextIsNull();
            return;
        }
        super.unload();
        ((AmazonRegistrationService)a2.getService(AmazonRegistrationService.class)).removeRegistrationListener((RegistrationListener)a);
        Wireless a3 = (Wireless)a2.getService(Wireless.class);
        a3.removeWirelessListener((WirelessListener)a);
        ((DCPagedLandingPanel)a.B).removeAllItems();
        a.B = null;
    }

    public boolean shouldMarkHistory() {
        return true;
    }

    public void onRegistrationInfoChanged(RegistrationEvent a) {
        SettingsDisplayController a2;
        RegistrationEvent.RegistrationEventType a3 = a.getEventType();
        SwingUtilities.invokeLater((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void onWirelessEvent(WirelessEvent a) {
        SettingsDisplayController a2;
        a2.setupWifiNetworks(true);
    }

    protected String getHeaderBarText() {
        return ResourceBundle.getBundle("com.amazon.kindle.settings.resources.SettingsResources").getString("header");
    }

    protected void initPanel() {
    }

    private List getUpdatedWidgetList() {
        SettingsDisplayController a;
        boolean a2 = CommunicationUtils.isRegistered((Booklet)a.booklet);
        if (a.h != a2) {
            a.h = a2;
            a.setupRegistration(true);
        }
        return a.h ? a.k : a.m;
    }

    private void initWidgets() {
        this.setupRegistration(false);
        this.setupWifiNetworks(false);
        this.setupDevicePasscode(false);
        this.setupDeviceOptions();
        this.setupPageRefresh(false);
        this.setupReadingOptions();
        this.setupInternational();
        this.m = new ArrayList();
        this.m.add(this.j);
        this.m.add(this.g);
        this.m.add(this.e);
        this.m.add(this.c);
        this.m.add(this.F);
        this.k = new ArrayList();
        this.k.add(this.j);
        this.k.add(this.g);
        this.k.add(this.I);
        this.k.add(this.L);
        this.k.add(this.c);
    }

    private void setupRegistration(boolean a) {
        String a2;
        String a3;
        String a4;
        SettingsDisplayController a5;
        ResourceBundle a6 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.SettingsResources");
        if (CommunicationUtils.isRegistered((Booklet)a5.booklet)) {
            a4 = a6.getString("reg.property.name.yes");
            a3 = CommunicationUtils.getUser((Booklet)a5.booklet);
            a2 = a3 != null ? a3 : a6.getString("reg.property.value.default.yes");
        } else {
            a4 = a6.getString("reg.property.name.no");
            a2 = a6.getString("reg.property.value.default.no");
        }
        if (a) {
            a5.M.addProperty("REGISTERED_USER", a4, (Object)a2);
            a5.M.refresh();
        } else {
            a3 = new /* Unavailable Anonymous Inner Class!! */;
            a5.M = new DefaultDetailElementModel(a6.getString("reg.name.label"), a6.getString("reg.description.label"), (Action)((Object)a3));
            a5.M.addProperty("REGISTERED_USER", a4, (Object)a2);
            a5.j = new SettingsElementView(a5.M);
        }
    }

    private void setupDevicePasscode(boolean a) {
        SettingsDisplayController a2;
        String a3;
        ResourceBundle a4 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.SettingsResources");
        String string = a3 = PasscodeUtils.isPasscodeEnabled((Booklet)a2.booklet) ? a4.getString("passcode.property.value.enabled") : a4.getString("passcode.property.value.disabled");
        if (a) {
            a2.G.addProperty("DEVICE_PASSCODE", a4.getString("passcode.property.name"), (Object)a3);
            a2.G.refresh();
        } else {
            3 a5 = new /* Unavailable Anonymous Inner Class!! */;
            a2.G = new DefaultDetailElementModel(a4.getString("passcode.name.label"), a4.getString("passcode.description.label"), (Action)a5);
            a2.G.addProperty("DEVICE_PASSCODE", a4.getString("passcode.property.name"), (Object)a3);
            a2.e = new SettingsElementView(a2.G);
        }
    }

    private void setupDeviceOptions() {
        SettingsDisplayController a;
        ResourceBundle a2 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.SettingsResources");
        4 a3 = new /* Unavailable Anonymous Inner Class!! */;
        a.a = new DefaultDetailElementModel(a2.getString("deviceoptions.name.label"), a2.getString("deviceoptions.description.label"), (Action)a3);
        a.I = new SettingsElementView(a.a);
    }

    private void setupPageRefresh(boolean a) {
        SettingsDisplayController a2;
        ResourceBundle a3 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.SettingsResources");
        String a4 = a3.getString("pagerefresh.property.name");
        if (a) {
            PageRefreshAction a5 = (PageRefreshAction)a2.i.getItemAction();
            Boolean a6 = (Boolean)a5.getActionState();
            a2.i.setSingleBooleanPropertyValue(a6);
            a2.i.refresh();
        } else {
            PageRefreshAction a7 = new PageRefreshAction((SettingsBooklet)a2.booklet);
            a2.i = new DefaultDetailElementModel(a3.getString("pagerefresh.name.label"), a3.getString("pagerefresh.description.label"), (Action)a7);
            a2.i.addProperty("PAGE_REFRESH", a4, a7.getActionState());
            a2.F = new SettingsElementView(a2.i, 1);
        }
    }

    private void setupReadingOptions() {
        SettingsDisplayController a;
        ResourceBundle a2 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.SettingsResources");
        5 a3 = new /* Unavailable Anonymous Inner Class!! */;
        a.E = new DefaultDetailElementModel(a2.getString("readingoptions.name.label"), a2.getString("readingoptions.description.label"), (Action)a3);
        a.L = new SettingsElementView(a.E);
    }

    private void setupDictionaries() {
        SettingsDisplayController a;
        ResourceBundle a2 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.SettingsResources");
        6 a3 = new /* Unavailable Anonymous Inner Class!! */;
        a.C = new DefaultDetailElementModel(a2.getString("dictionary.name.label"), a2.getString("dictionary.description.label"), (Action)a3);
        a.c = new SettingsElementView(a.C);
    }

    private void setupWifiNetworks(boolean a) {
        SettingsDisplayController a2;
        if (a) {
            a2.updateWifiCount();
            a2.updateWifiConnection();
        } else {
            ResourceBundle a3 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.SettingsResources");
            7 a4 = new /* Unavailable Anonymous Inner Class!! */;
            a2.J = new DefaultDetailElementModel(a3.getString("wifi.name.label"), a3.getString("wifi.description.label"), (Action)a4);
            a2.J.addProperty("WIFI_NETWORK_COUNT", a3.getString("wifi.property.name.count"), (Object)new Integer(0));
            a2.J.addProperty("WIFI_CONNECTION", a3.getString("wifi.property.name.connected.no"), (Object)a3.getString("wifi.property.value.connected.no.default"));
            a2.g = new SettingsElementView(a2.J);
        }
    }

    private void setupInternational() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.SettingsResources");
        8 var2_2 = new /* Unavailable Anonymous Inner Class!! */;
        this.d = new DefaultDetailElementModel(resourceBundle.getString("international.name.label"), resourceBundle.getString("international.description.label"), (Action)var2_2);
        this.c = new SettingsElementView(this.d);
    }

    private void updateWifiCount() {
        try {
            SettingsDisplayController a;
            if (NetworkUtils.hasWifi((Booklet)a.booklet)) {
                BookletContext a2 = a.booklet.getBookletContext();
                if (a2 == null) {
                    LogUtils.logBookletContextIsNull();
                    return;
                }
                if (((Wireless)a2.getService(Wireless.class)).isWirelessSwitchOn()) {
                    SwingUtilities.invokeLater((Runnable)a.A);
                } else {
                    ResourceBundle a3 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.SettingsResources");
                    a.J.addProperty("WIFI_NETWORK_COUNT", a3.getString("wifi.property.name.count"), (Object)new Integer(0));
                    a.J.refresh();
                }
            }
        }
        catch (Exception a) {
            u.error(Log.CATCHALL_EX, "error updating wifi networks count");
        }
    }

    private void updateWifiConnection() {
        try {
            SettingsDisplayController a;
            if (NetworkUtils.hasWifi((Booklet)a.booklet)) {
                String a2;
                String a3;
                BookletContext a4 = a.booklet.getBookletContext();
                if (a4 == null) {
                    LogUtils.logBookletContextIsNull();
                    return;
                }
                WiFiNetwork a5 = ((WiFi)a4.getService(WiFi.class)).getConnectedNetwork();
                ResourceBundle a6 = ResourceBundle.getBundle("com.amazon.kindle.settings.resources.SettingsResources");
                if (a5 != null) {
                    a3 = a6.getString("wifi.property.name.connected.yes");
                    a2 = a5.getSSID();
                } else {
                    a3 = a6.getString("wifi.property.name.connected.no");
                    a2 = a6.getString("wifi.property.value.connected.no.default");
                }
                a.J.addProperty("WIFI_CONNECTION", a3, (Object)a2);
                a.J.refresh();
            }
        }
        catch (Exception a) {
            u.error("Service Access Error: WiFi");
        }
    }

    static /* synthetic */ DCBooklet access$100(SettingsDisplayController a) {
        return a.booklet;
    }

    static /* synthetic */ DCBooklet access$200(SettingsDisplayController a) {
        return a.booklet;
    }

    static /* synthetic */ DCBooklet access$300(SettingsDisplayController a) {
        return a.booklet;
    }

    static /* synthetic */ DCBooklet access$400(SettingsDisplayController a) {
        return a.booklet;
    }

    static /* synthetic */ DCBooklet access$500(SettingsDisplayController a) {
        return a.booklet;
    }

    static /* synthetic */ ShowWiFiNetworksRunnable access$600(SettingsDisplayController a) {
        return a.H;
    }

    static /* synthetic */ DCBooklet access$700(SettingsDisplayController a) {
        return a.booklet;
    }

    static /* synthetic */ DCBooklet access$800(SettingsDisplayController a) {
        return a.booklet;
    }

    static /* synthetic */ Log access$900() {
        return u;
    }

    static /* synthetic */ DCBooklet access$1000(SettingsDisplayController a) {
        return a.booklet;
    }

    static /* synthetic */ DetailElementModel access$1100(SettingsDisplayController a) {
        return a.J;
    }

    static /* synthetic */ void access$1300(SettingsDisplayController a, boolean a2) {
        a.setupWifiNetworks(a2);
    }
}

