/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html.nodoc;

import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public abstract class SequentialListSegment
extends Segment
implements List {
    public SequentialListSegment(Source source, int n, int n2) {
        super(source, n, n2);
    }

    public abstract int getCount();

    public abstract ListIterator listIterator(int var1);

    public Object get(int n) {
        ListIterator listIterator = this.listIterator(n);
        try {
            return listIterator.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IndexOutOfBoundsException("index=" + n);
        }
    }

    public int size() {
        return this.getCount();
    }

    public boolean isEmpty() {
        return this.getCount() == 0;
    }

    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.getCount()];
        int n = 0;
        ListIterator listIterator = this.listIterator(0);
        while (listIterator.hasNext()) {
            objectArray[n++] = listIterator.next();
        }
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        int n = this.getCount();
        if (objectArray.length < n) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        }
        int n2 = 0;
        ListIterator listIterator = this.listIterator(0);
        while (listIterator.hasNext()) {
            objectArray[n2++] = listIterator.next();
        }
        if (objectArray.length > n) {
            objectArray[n] = null;
        }
        return objectArray;
    }

    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean add(Object object) {
        throw new UnsupportedOperationException();
    }

    public Object set(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    public void add(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    public Object remove(int n) {
        throw new UnsupportedOperationException();
    }

    public int indexOf(Object object) {
        ListIterator listIterator = this.listIterator(0);
        if (object == null) {
            while (listIterator.hasNext()) {
                if (listIterator.next() != null) continue;
                return listIterator.previousIndex();
            }
        } else {
            while (listIterator.hasNext()) {
                if (!object.equals(listIterator.next())) continue;
                return listIterator.previousIndex();
            }
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        ListIterator listIterator = this.listIterator(this.getCount());
        if (object == null) {
            while (listIterator.hasPrevious()) {
                if (listIterator.previous() != null) continue;
                return listIterator.nextIndex();
            }
        } else {
            while (listIterator.hasPrevious()) {
                if (!object.equals(listIterator.previous())) continue;
                return listIterator.nextIndex();
            }
        }
        return -1;
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int n, Collection collection) {
        throw new UnsupportedOperationException();
    }

    public Iterator iterator() {
        return this.listIterator();
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public List subList(int n, int n2) {
        return new SubList(this, n, n2);
    }

    private static class SubList
    extends AbstractList {
        private final List list;
        private final int offset;
        private final int size;

        SubList(List list, int n, int n2) {
            if (n < 0) {
                throw new IndexOutOfBoundsException("fromIndex=" + n);
            }
            if (n2 > list.size()) {
                throw new IndexOutOfBoundsException("toIndex=" + n2);
            }
            if (n > n2) {
                throw new IllegalArgumentException("fromIndex(" + n + ") > toIndex(" + n2 + ")");
            }
            this.list = list;
            this.offset = n;
            this.size = n2 - n;
        }

        public Object get(int n) {
            return this.list.get(this.getSuperListIndex(n));
        }

        public int size() {
            return this.size;
        }

        public Iterator iterator() {
            return this.listIterator();
        }

        public ListIterator listIterator(int n) {
            return new ListIterator(this, n){
                private final ListIterator i;
                private final /* synthetic */ int val$index;
                private final /* synthetic */ SubList this$0;
                {
                    this.this$0 = subList;
                    this.val$index = n;
                    this.i = SubList.access$100(this.this$0).listIterator(SubList.access$000(this.this$0, this.val$index));
                }

                public boolean hasNext() {
                    return this.nextIndex() < SubList.access$200(this.this$0);
                }

                public Object next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return this.i.next();
                }

                public boolean hasPrevious() {
                    return this.previousIndex() >= 0;
                }

                public Object previous() {
                    if (!this.hasPrevious()) {
                        throw new NoSuchElementException();
                    }
                    return this.i.previous();
                }

                public int nextIndex() {
                    return this.i.nextIndex() - SubList.access$300(this.this$0);
                }

                public int previousIndex() {
                    return this.i.previousIndex() - SubList.access$300(this.this$0);
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }

                public void set(Object object) {
                    throw new UnsupportedOperationException();
                }

                public void add(Object object) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public List subList(int n, int n2) {
            return new SubList(this, n, n2);
        }

        private int getSuperListIndex(int n) {
            if (n < 0 || n >= this.size) {
                throw new IndexOutOfBoundsException("index=" + n + ", size=" + this.size);
            }
            return n + this.offset;
        }

        static /* synthetic */ int access$000(SubList subList, int n) {
            return subList.getSuperListIndex(n);
        }

        static /* synthetic */ List access$100(SubList subList) {
            return subList.list;
        }

        static /* synthetic */ int access$200(SubList subList) {
            return subList.size;
        }

        static /* synthetic */ int access$300(SubList subList) {
            return subList.offset;
        }
    }
}

