/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StartTag;
import au.id.jericho.lib.html.SubCache;
import au.id.jericho.lib.html.Tag;
import au.id.jericho.lib.html.TagType;
import java.util.Iterator;
import java.util.List;

final class Cache {
    public final Source source;
    private final SubCache allTagTypesSubCache;
    private final SubCache[] subCaches;

    public Cache(Source source) {
        this.source = source;
        this.allTagTypesSubCache = new SubCache(this, null);
        TagType[] tagTypeArray = Cache.getSeparatelyCachedTagTypes();
        this.subCaches = new SubCache[tagTypeArray.length + 1];
        this.subCaches[0] = this.allTagTypesSubCache;
        for (int i = 0; i < tagTypeArray.length; ++i) {
            this.subCaches[i + 1] = new SubCache(this, tagTypeArray[i]);
        }
    }

    public void clear() {
        for (int i = 0; i < this.subCaches.length; ++i) {
            this.subCaches[i].clear();
        }
    }

    public Tag getTagAt(int n) {
        return this.source.useAllTypesCache ? this.allTagTypesSubCache.getTagAt(n) : Tag.getTagAtUncached(this.source, n);
    }

    public Tag findPreviousOrNextTag(int n, boolean bl) {
        return this.allTagTypesSubCache.findPreviousOrNextTag(n, bl);
    }

    public Tag findPreviousOrNextTag(int n, TagType tagType, boolean bl) {
        int n2;
        int n3 = n2 = this.source.useAllTypesCache ? 0 : 1;
        while (n2 < this.subCaches.length) {
            if (tagType == this.subCaches[n2].tagType) {
                return this.subCaches[n2].findPreviousOrNextTag(n, bl);
            }
            ++n2;
        }
        return Tag.findPreviousOrNextTagUncached(this.source, n, tagType, bl, -1);
    }

    public Tag addTagAt(int n) {
        Tag tag = Tag.getTagAtUncached(this.source, n);
        this.allTagTypesSubCache.addTagAt(n, tag);
        if (tag == null) {
            return tag;
        }
        TagType tagType = tag.getTagType();
        for (int i = 1; i < this.subCaches.length; ++i) {
            if (tagType != this.subCaches[i].tagType) continue;
            this.subCaches[i].addTagAt(n, tag);
            return tag;
        }
        return tag;
    }

    public int getTagCount() {
        return this.allTagTypesSubCache.size() - 2;
    }

    public Iterator getTagIterator() {
        return this.allTagTypesSubCache.getTagIterator();
    }

    public void loadAllTags(List list, Tag[] tagArray, StartTag[] startTagArray) {
        int n;
        int n2 = list.size();
        this.allTagTypesSubCache.bulkLoad_Init(n2);
        int n3 = 0;
        int n4 = 0;
        block0: for (n = 0; n < n2; ++n) {
            Tag tag = (Tag)list.get(n);
            if (!tag.isUnregistered()) {
                tagArray[n3++] = tag;
                if (tag instanceof StartTag) {
                    startTagArray[n4++] = (StartTag)tag;
                }
            }
            this.allTagTypesSubCache.bulkLoad_Set(n, tag);
            for (int i = 1; i < this.subCaches.length; ++i) {
                if (tag.getTagType() != this.subCaches[i].tagType) continue;
                this.subCaches[i].bulkLoad_AddToTypeSpecificCache(tag);
                continue block0;
            }
        }
        for (n = 1; n < this.subCaches.length; ++n) {
            this.subCaches[n].bulkLoad_FinaliseTypeSpecificCache();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.subCaches.length; ++i) {
            this.subCaches[i].appendTo(stringBuffer);
        }
        return stringBuffer.toString();
    }

    protected int getSourceLength() {
        return this.source.end;
    }

    private static TagType[] getSeparatelyCachedTagTypes() {
        return TagType.getTagTypesIgnoringEnclosedMarkup();
    }
}

