/*
 * Decompiled with CFR 0.152.
 */
package at.laborg.derstandardreader.gui;

import at.laborg.derstandardreader.StandardReader;
import at.laborg.derstandardreader.model.Ressort;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DerStandardChooser
implements ActionListener {
    private JCheckBox[] ressortCheckers;
    private StandardReader sReader = new StandardReader();
    private JFrame frame;

    public DerStandardChooser() throws IOException, ParseException {
        this.sReader.reloadRessorts();
        this.frame = new JFrame("DerStandardReader");
        this.frame.setDefaultCloseOperation(3);
        JLabel textLabel = new JLabel("W\u00e4hlen sie die Ressorts, aus denen die aktuellen Artikel geladen werden");
        JPanel panel = new JPanel(new GridLayout(0, 2));
        this.frame.getContentPane().add((Component)textLabel, "North");
        this.ressortCheckers = new JCheckBox[this.sReader.getRessorts().size()];
        int i = 0;
        for (Ressort ressort : this.sReader.getRessorts()) {
            this.ressortCheckers[i] = new JCheckBox(ressort.getName());
            panel.add(this.ressortCheckers[i++]);
        }
        this.frame.getContentPane().add((Component)panel, "Center");
        JButton loadStandardButton = new JButton("Lade den Standard");
        loadStandardButton.addActionListener(this);
        this.frame.getContentPane().add((Component)loadStandardButton, "South");
        this.frame.pack();
        this.frame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        ArrayList<String> selectedRessorts = new ArrayList<String>();
        JCheckBox[] jCheckBoxArray = this.ressortCheckers;
        int n = this.ressortCheckers.length;
        int n2 = 0;
        while (n2 < n) {
            JCheckBox jCheckBox = jCheckBoxArray[n2];
            if (jCheckBox.isSelected()) {
                selectedRessorts.add(jCheckBox.getText());
            }
            ++n2;
        }
        this.sReader.setSelectedRessorts(selectedRessorts);
        try {
            this.sReader.readArticleIDs();
            this.sReader.fillArticles();
            JFileChooser jFC = new JFileChooser();
            Date now = new Date();
            SimpleDateFormat sDF = new SimpleDateFormat("dd-MM");
            jFC.setSelectedFile(new File("Standard" + sDF.format(now) + ".htm"));
            int ret = jFC.showSaveDialog(this.frame);
            if (ret == 0) {
                File saveFile = jFC.getSelectedFile();
                if (!saveFile.exists()) {
                    saveFile.createNewFile();
                }
                this.sReader.writeout(saveFile);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }
}

