/*
 * Decompiled with CFR 0.152.
 */
package at.laborg.derstandardreader;

import at.laborg.derstandardreader.gui.DerStandardChooser;
import at.laborg.derstandardreader.model.Article;
import at.laborg.derstandardreader.model.Ressort;
import au.id.jericho.lib.html.Element;
import au.id.jericho.lib.html.Source;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StandardReader {
    private ArrayList<Ressort> ressorts = new ArrayList();
    private HashMap<Ressort, HashMap<Integer, Article>> newspaper = new HashMap();
    private final String WEBSTANDARD_URL_STRING_PDA = "http://derstandard.at/PDA/?id=";
    private final String WEBSTANDARD_URL_STRING = "http://derstandard.at/PDA/";
    private final String WEBSTANDARD_URL_STRING_RESSORT = "http://derstandard.at/PDA/?ressort=";
    private final long MILLISECONDS_IN_A_DAY = 86400000L;
    private final String REGEX_ID_LINK = "\\?id=[0-9]{7}";
    private final String REGEX_RESSORT_LINK = "\\?ressort=";

    public ArrayList<URL> getURLSforSelectedRessorts() throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Ressort ressort : this.getSelectedRessorts()) {
            urls.add(this.getURLforRessort(ressort));
        }
        return urls;
    }

    private URL getURLforRessort(Ressort ressort) throws MalformedURLException {
        return new URL("http://derstandard.at/PDA/?ressort=" + ressort.getName());
    }

    private List<Element> getLinks(URL url) throws IOException {
        Source source = new Source(url);
        return source.findAllElements("a");
    }

    public void readArticleIDs() throws IOException {
        for (Ressort ressort : this.getSelectedRessorts()) {
            HashMap<Integer, Article> articles = new HashMap<Integer, Article>();
            List<Element> anchorList = this.getLinks(this.getURLforRessort(ressort));
            for (Element aElement : anchorList) {
                String idString;
                Integer id;
                String target = aElement.getAttributeValue("href");
                if (!target.matches("\\?id=[0-9]{7}") || articles.containsKey(id = Integer.valueOf(idString = target.substring(4)))) continue;
                Article article = new Article(id);
                articles.put(id, article);
            }
            this.newspaper.put(ressort, articles);
        }
    }

    public void fillArticles() throws IOException, ParseException {
        for (Ressort ressort : this.getSelectedRessorts()) {
            for (Article article : this.newspaper.get(ressort).values()) {
                String tmpURLString = "http://derstandard.at/PDA/?id=" + article.getId();
                URL tmpURL = new URL(tmpURLString);
                Source source = new Source(tmpURL);
                List paragraphList = source.findAllElements("p");
                SimpleDateFormat sDF = new SimpleDateFormat("dd.MM.yyyy HH:mm");
                Date now = new Date();
                try {
                    Date dt = sDF.parse(((Element)paragraphList.get(0)).getTextExtractor().toString());
                    if (now.getTime() - dt.getTime() >= 86400000L) continue;
                    article.setDate(dt);
                    article.setTitle(((Element)paragraphList.get(1)).getTextExtractor().toString());
                    article.setText(((Element)paragraphList.get(2)).getTextExtractor().toString());
                    article.setProcessed(true);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void reloadRessorts() throws IOException {
        URL tmpURL = new URL("http://derstandard.at/PDA/");
        List<Element> anchorList = this.getLinks(tmpURL);
        Pattern linkPattern = Pattern.compile("\\?ressort=");
        for (Element aElement : anchorList) {
            Ressort ressort;
            String target = aElement.getAttributeValue("href");
            Matcher m = linkPattern.matcher(target);
            if (!m.find() || this.ressorts.contains(ressort = new Ressort(target.substring(m.end(), target.length())))) continue;
            this.ressorts.add(ressort);
        }
    }

    public void setSelectedRessorts(ArrayList<String> ressortStrings) {
        for (String ressortString : ressortStrings) {
            Ressort tmpRessort = new Ressort(ressortString);
            tmpRessort.setSelected(false);
            if (!this.ressorts.contains(tmpRessort)) continue;
            this.ressorts.get(this.ressorts.indexOf(tmpRessort)).setSelected(true);
        }
    }

    public ArrayList<Ressort> getRessorts() throws IOException {
        return this.ressorts;
    }

    public ArrayList<Ressort> getSelectedRessorts() {
        ArrayList<Ressort> tmp = new ArrayList<Ressort>();
        for (Ressort ressort : this.ressorts) {
            if (!ressort.isSelected()) continue;
            tmp.add(ressort);
        }
        return tmp;
    }

    public void writeout(File file) throws IOException {
        FileWriter fw = new FileWriter(file);
        StringBuilder index = new StringBuilder();
        StringBuilder content = new StringBuilder();
        StringBuilder output = new StringBuilder();
        output.append("<html><body>");
        for (Ressort ressort : this.getSelectedRessorts()) {
            index.append("<h3>" + ressort.getName() + "</h3>");
            for (Article article : this.newspaper.get(ressort).values()) {
                if (!article.isProcessed().booleanValue() || article.getText().isEmpty()) continue;
                index.append("<a href=\"#" + article.getId() + "\">" + article.getTitle() + "</a><br /><br />");
                content.append(article.toHTML());
            }
        }
        output.append((CharSequence)index);
        output.append("<br>");
        output.append((CharSequence)content);
        output.append("</body></html>");
        fw.write(output.toString());
        fw.close();
    }

    public static void main(String[] args) throws MalformedURLException, Exception {
        new DerStandardChooser();
    }
}

