#ifndef INPUT_WIDGET_H_
#define INPUT_WIDGET_H_

#include <onyx/ui/buttons.h>
#include <onyx/ui/line_edit.h>
#include <onyx/ui/onyx_dialog.h>
#include <onyx/ui/keyboard.h>

namespace ui
{

/// Password widget to enable user to change search criteria.
class InputWidget : public OnyxDialog
{
    Q_OBJECT

public:
    InputWidget(QWidget *parent, QString title, QString initstring);
    ~InputWidget(void);

public:
    int popup();
    QString password();
	//int exec();

protected:
    void mouseMoveEvent(QMouseEvent *me);
    void mousePressEvent(QMouseEvent *me);
    void mouseReleaseEvent(QMouseEvent *me);
    void keyReleaseEvent(QKeyEvent *);
    void keyPressEvent(QKeyEvent * ke);
    bool event(QEvent * event);
    void moveEvent(QMoveEvent *e);
    void resizeEvent(QResizeEvent *e);
    bool eventFilter(QObject *obj, QEvent *event);

private Q_SLOTS:
    void onShowPlainTextClicked();
    void onOKClicked();
    void onCloseClicked();
    void onTimeout();
    void onTextChanged(const QString& text);

private:
    void createLayout();

protected:
    OnyxCheckBox   show_plain_text_;   ///< Show plain text or star.

private:
    QHBoxLayout  hbox_;

    OnyxLineEdit text_edit_;    ///< Input edit.
    OnyxPushButton ok_button_;
    OnyxPushButton clear_button_;

    KeyBoard      keyboard_;     ///< Keyboard.
    QTimer        timer_;        ///< Timer to update the screen.
};


};  // namespace ui

#endif  
