# -*- coding: utf-8 -*-
# -*- coding: utf-8 -*-

__license__ = 'GPL 3'
__copyright__ = '2011, Jesse Chisholm <jesse.chisholm@gmail.com>'
__docformat__ = 'restructuredtext en'

import os, re

from common import DEBUG
from common import VERBOSE
from common import log
from common import AUDIOBOOK_KNOWN_GENRE
from common import AudioBookException
from baseWrapper import baseWrapper

###############################################################################
#
#   a convenience class to use eyed3 to fetch the information we need
#   and allow easy requests for information fields, whether they exist or not.
#
#   usage:
#      iw = id3Wrapper(afile)
#      title = iw.get('title')                  # None returned if not available
#      author = iw.get('author', _('Unknown'))  # specify a default value
#
class id3Wrapper(baseWrapper):
    # @param:afile - the open file object, or the path to a file
    # @throws: IOError if afile is not one of the above
    #
    def __init__(self, afile):
        baseWrapper.__init__(self, afile)

    def _parse_file(self, afile):
        tname = self.filename
        if -1 != self.filename.find('://'):
            if VERBOSE: print("debug: id3Wrapper: file : %s" % (tname))
            (dir, name) = os.path.split(self.filename)
            tname = os.path.join(os.getcwd(),name)
            self._copy_file(self.filename,tname)
        import eyeD3
        if VERBOSE: print("debug: id3Wrapper: file : %s" % (tname))
        log.debug("id3Wrapper: file : %s" % (tname))
        mp3File = eyeD3.Mp3AudioFile(tname);
        if not mp3File:
            if VERBOSE: print("debug: id3Wrapper: no file : %s" % (tname))
            log.error("id3Wrapper: no file : %s" % (tname))
            return None
        tags = mp3File.getTag()
        if not tags:
            if VERBOSE: print("debug: id3Wrapper: no file : %s" % (tname))
            log.error("id3Wrapper: no file : %s" % (tname))
            return None

        # learn what we can from this file
        #
        genre = tags.getGenre();    # really getGenreFrame();
        if genre: genre = genre.getName();
        title = tags.getTitle();
        title_sort = title; # for now
        album = tags.getAlbum();
        author = tags.getArtist();
        track = tags.getTrackNum();    # returns a tuple (track#, numTracks)
        track = track and track[0] or None;
        chapter = track and ("%s" % (track)) or None;
        temp = tags.getComments()      # really getCommentsFrameList
        comments = []
        if temp:
            for t in temp:
                comments.append( [ t.lang, t.description, t.comment ] )
        (cover, cover_data) = _fetch_mp3_cover(tags)
        #
        # now some patching up
        #
        if title and not album:
            album = title;
            # <album> <chapter> <author> <compression>
            temp = re.match("(.*?)([0-9]+\.?[0-9]*)(.*?)(\d+\w+)",title);
            if temp:
                album = temp.group(1).replace('_',' ').strip();
                title = album;
                chapter = temp.group(2).strip();
                if not author:
                    author = temp.group(3).replace('_',' ').strip();
                else:
                    title = temp.group(3).replace('_',' ').strip();
                # compression = temp.group(4).strip();
        temp = chapter and re.match("0+(\d+)",chapter) or None;
        if temp: chapter = temp.group(1);
        if chapter and chapter not in title:
            title_sort = ("%s. %s" % ((len(chapter)==1 and "0"+chapter or chapter), title));
        elif title:
            title_sort = title
        publisher = tags.getPublisher();
        if author and not publisher:
            temp = re.match("(.*?)-(.*)",author);
            if temp:
                author = temp.group(1).strip();
                publisher = temp.group(2).strip();
        dateFrame = tags.getDate();    # really getFrameList(DateFrame)
        pubdate = dateFrame and dateFrame[0].getDate() or tags.getYear() or None;
        #
        # NOTE: we _allow_ MP3 files other than 'Audio Books' and 'Speech'
        #       because there is no real point in restricting it,
        #       despite the module name.
        #
        # TODO: what if there is also a 'mood' or other field for tags ?
        #
        genre_list = []
        if genre:
            genre_list.append(genre)
            ok = False;
            for entry in AUDIOBOOK_KNOWN_GENRE:
                ok = (genre.strip().lower() == entry.lower()) or ok;
            if not ok:
                print ("warning: Genre unexpected: '%s'" % (genre));
                log.warning("Genre unexpected: '%s'" % (genre));
                genre_list.append(AUDIOBOOK_KNOWN_GENRE[0])
        else:
            # just to have something for the tags field.
            genre_list.append(AUDIOBOOK_KNOWN_GENRE[0])
        #
        # now set it all for the convenience of our owner
        #
        if title: self.set('title',title)
        if title_sort: self.set('title_sort',title_sort)
        if album: self.set('series',album)
        if chapter: self.set('series_index',float(chapter))
        if author:
            if "&" in author:
                aus = author.split("&")
                for a in range(0,len(aus)): aus[a] = aus[a].strip()
                self.set('authors',aus)
            elif " and " in author:
                aus = author.split(" and ")
                for a in range(0,len(aus)): aus[a] = aus[a].strip()
                self.set('authors',aus)
            else:
                self.set('authors',[author])
        self.set('tags',genre_list)
        if publisher: self.set('publisher',publisher)
        if pubdate: self.set('pubdate',pubdate)
        if comments:
            html = []
            html.append("<table border='0'>")
            html.append("<tr><th>Language</th><th>Comment</th></tr>")
            html_ok = 0
            for c in comments:
                # [ lang, desc, long_text ]
                (lang, desc, text) = c
                if VERBOSE: print "debug: comment.lang:", lang
                if VERBOSE: print "debug: comment.desc:", desc
                if VERBOSE: print "debug: comment.text:", text
                
                # the first comment can set the language of the book.
                if lang and not self.has('language'):
                    self.set('language', lang)
                # only useful comments get copied over
                if desc or text or DEBUG:
                    html.append("<tr><th>%s</th>" % (lang))
                    html.append("    <td><table border='0'><tr><th>%s</th></tr>" % (desc))
                    html.append("        <tr><td>%s</td></tr></table></td></tr>" % (text))
                    html_ok = 1
            html.append("</table>")
            html = "\n".join(html)
            # only if at least one useful comment ...
            if html_ok:
                self.set('comments',html)
        #
        # TODO: does tags have anything for stream mime?
        #
        self.set('mime',"audio/mpeg")
        self.set('#duration', -1)   # just don't know
        #
        if -1 != self.filename.find('://'):
            os.remove(tname)

######################################################

# fetch an image from the same directory as the audio file
# @param:dir - the directory to look in
# @param:name - the name of the file (sans extension)
# @param:id3tags - the collection of tags extracted from eyed3.tags()
# @return:
#     on failure: tuple (None, None)
#     on success: tuple (filepath, (mimetype, imagedata))
#
def _fetch_mp3_cover(id3tags):
    # from . import eyeD3
    import eyeD3
    cover, cover_data = None, None;
    images = id3tags.getImages();   # a possibly empty list of ImageFrame
    if VERBOSE: print ("debug: id3tags.images: %s" % (images));
    # check for "cover" art in MP3 file.
    if images:
        # prefer img.pictureType == ImageFrame.FRONT_COVER.
        for img in images:
            if VERBOSE:
                print ("debug: id3tags.img: %s == %s" % (
                    eyeD3.frames.ImageFrame.picTypeToString(img.pictureType),
                    img.mimeType))
            if img.imageData and img.pictureType==eyeD3.frames.ImageFrame.FRONT_COVER:
                cover = img.imageURL or img.getDefaultFileName();
                cover_data = (img.mimeType, img.imageData);
                break;
        # ... but I'll take anything.
        if not cover_data:
            for img in images:
                if img.imageData:
                    print ("debug: id3tags.img: %s == %s" % (
                        eyeD3.frames.ImageFrame.picTypeToString(img.pictureType),
                        img.mimeType))
                    cover = img.imageURL or img.getDefaultFileName();
                    cover_data = (img.mimeType, img.imageData);
                    break;
    #
    return (cover, cover_data);

######################################################
