# -*- coding: utf-8 -*-
# -*- coding: utf-8 -*-

__license__ = 'GPL 3'
__copyright__ = '2011, Jesse Chisholm <jesse.chisholm@gmail.com>'
__docformat__ = 'restructuredtext en'

import os, re

from common import DEBUG
from common import VERBOSE
from common import log
from common import AUDIOBOOK_KNOWN_GENRE
from common import AudioBookException
from baseWrapper import baseWrapper
import flvlib
from flvlib import tags
from flvlib.astypes import MalformedFLV

###############################################################################
#
#   a convenience class to use flvlib to fetch the information we need
#   and allow easy requests for information fields, whether they exist or not.
#
#   usage:
#      fw = flvWrapper(afile)
#      title = fw.get('title')                  # None returned if not available
#      author = fw.get('author', _('Unknown'))  # specify a default value
#
class flvWrapper(baseWrapper):
    # @param:afile - the open file object, or the path to a file
    # @throws: IOError if afile is not one of the above
    #
    def __init__(self, afile):
        baseWrapper.__init__(self, afile)

    def _parse_file(self, afile):
        if type(afile) is str:
            if VERBOSE: print("debug: flvWrapper: filename : %s" % (afile))
            if -1 != self.filename.find('://'):
                import urllib2
                f = urllib2.urlopen(self.filename)
            else:
                f = file(self.filename,'rb')
            try:
                flv = tags.FLV(f)
                self._fetch_tags(flv)
            finally:
                f.close()
        elif type(afile) is file:
            if VERBOSE: print("debug: flvWrapper: file : %s" % (self.filename))
            try:
                flv = flvlib.tags.FLV(afile)
                self._fetch_tags(flv)
            finally:
                pass
        else:
            print("error: unknown argument type: %s" % (type(afile)))
            log.error("unknown argument type: %s" % (type(afile)))
            raise AudioBookException("flvWrapper can't handle argument of type: %s" % (type(afile)))
        #
        # Now to 'canonicalize' it all
        #
        if VERBOSE:
            print "debug: --- begin --- flv file tag collection before 'canonicalization'"
            # because we don't care to see this kruft
            if self.has('keyframes'): self.set('keyframes', '{...}')
            if self.has('cuepoints'): self.set('cuepoints', '[...]')
            self.dump()
            print "debug: ---- end ---- flv file tag collection before 'canonicalization'"
        #
        self.set('pubdate', self.get('metadatadate'));
        self.rem('metadatadate')
        self.set('#duration', self.get('duration'));
        self.rem('duration')
        codec = int(self.get('audiocodecid','0'))
        codec_to_string = [ # names shortened from flvlib.constants.sound_format_to_string
            "PCM", "ADPCM", "MP3", "PCM", "Nellymoser", "Nellymoser", "Nellymoser",
            "A-law", "mu-law", "AAC", "Speex", "MP3", "x-audio"]
        self.set('mime', "audio/%s" % (codec_to_string[codec]))
        self.rem('audiocodecid')
        #
        #
        #   add some things we are just guessing at
        #
        self.set('tags', [AUDIOBOOK_KNOWN_GENRE[0]])
        #
        # remove expected things from flv file we don't care about
        #
        for t in ['hasKeyframes', 'cuePoints', 'audiodatarate', 'hasVideo',
                  'stereo', 'canSeekToEnd', 'framerate', 'audiosamplerate',
                  'videocodecid', 'datasize', 'lasttimestamp', 'audiosamplesize',
                  'audiosize', 'hasAudio', 'audiodelay', 'videosize',
                  'metadatacreator', 'lastkeyframetimestamp', 'height', 'filesize',
                  'hasMetadata', 'keyframes', 'videodatarate', 'hasCuePoints',
                  'width',
                 ]:
            self.rem(t)
        #
        if VERBOSE:
            print "debug: --- begin --- flv file tag collection after 'canonicalization'"
            self.dump()
            print "debug: ---- end ---- flv file tag collection after 'canonicalization'"

    def _fetch_tags(self, flv):
        try:
            tag_generator = flv.iter_tags()
            for i, tag in enumerate(tag_generator):
                log.debug("#%05d %s" % (i + 1, tag))
                if (isinstance(tag, tags.ScriptTag)
                    and tag.name == "onMetaData"):
                        # print tag.variable
                        for n in tag.variable:
                            v = tag.variable[n]
                            log.debug("     [%s] = %s" % (n,v))
                            self.set(n,v)
                        break   # there is only one onMetaData to parse
        except MalformedFLV, e:
            message = e[0] % e[1:]
            log.error("The file `%s' is not a valid FLV file: %s",
                      filename, message)
            return False
        except tags.EndOfFile:
            log.error("Unexpected end of file on file `%s'", filename)
            return False
        return True
###############################################################################

# fetch an image from the flv file
# @param:afile - the open .flv file
# @param:toc - the toc read from that file
# @return:
#     on failure: tuple (None, None)
#     on success: tuple (None, (mimetype, imagedata))
#
def _fetch_flv_cover(afile):
    mime, data = None, None
    # far as I know the FLV file does nto have a cover image embedded
    return (mime, data)

###############################################################################
